<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Datei StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Übertragung von Dateien. Besteht aus der ID des Objekts sowie den Binärdaten.
 * @subpackage Structs
 */
class Datei extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: ID der Datei
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The binaerdaten
     * Meta information extracted from the WSDL
     * - documentation: Binärdaten der Datei inklusive Metadaten.
     * @var \StructType\BinaryObject
     */
    public $binaerdaten;
    /**
     * Constructor method for Datei
     * @uses Datei::setId()
     * @uses Datei::setBinaerdaten()
     * @param \StructType\Identifikator $id
     * @param \StructType\BinaryObject $binaerdaten
     */
    public function __construct(\StructType\Identifikator $id = null, \StructType\BinaryObject $binaerdaten = null)
    {
        $this
            ->setId($id)
            ->setBinaerdaten($binaerdaten);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Datei
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get binaerdaten value
     * @return \StructType\BinaryObject|null
     */
    public function getBinaerdaten()
    {
        return $this->binaerdaten;
    }
    /**
     * Set binaerdaten value
     * @param \StructType\BinaryObject $binaerdaten
     * @return \StructType\Datei
     */
    public function setBinaerdaten(\StructType\BinaryObject $binaerdaten = null)
    {
        $this->binaerdaten = $binaerdaten;
        return $this;
    }
}
