<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataBlockType StructType
 * @subpackage Structs
 */
class DataBlockType extends AbstractStructBase
{
    /**
     * The rangeParameters
     * @var \StructType\AssociationRoleType
     */
    public $rangeParameters;
    /**
     * The tupleList
     * @var \StructType\CoordinatesType
     */
    public $tupleList;
    /**
     * The doubleOrNilReasonTupleList
     * @var list
     */
    public $doubleOrNilReasonTupleList;
    /**
     * Constructor method for DataBlockType
     * @uses DataBlockType::setRangeParameters()
     * @uses DataBlockType::setTupleList()
     * @uses DataBlockType::setDoubleOrNilReasonTupleList()
     * @param \StructType\AssociationRoleType $rangeParameters
     * @param \StructType\CoordinatesType $tupleList
     * @param list $doubleOrNilReasonTupleList
     */
    public function __construct(\StructType\AssociationRoleType $rangeParameters = null, \StructType\CoordinatesType $tupleList = null, list $doubleOrNilReasonTupleList = null)
    {
        $this
            ->setRangeParameters($rangeParameters)
            ->setTupleList($tupleList)
            ->setDoubleOrNilReasonTupleList($doubleOrNilReasonTupleList);
    }
    /**
     * Get rangeParameters value
     * @return \StructType\AssociationRoleType|null
     */
    public function getRangeParameters()
    {
        return $this->rangeParameters;
    }
    /**
     * Set rangeParameters value
     * @param \StructType\AssociationRoleType $rangeParameters
     * @return \StructType\DataBlockType
     */
    public function setRangeParameters(\StructType\AssociationRoleType $rangeParameters = null)
    {
        $this->rangeParameters = $rangeParameters;
        return $this;
    }
    /**
     * Get tupleList value
     * @return \StructType\CoordinatesType|null
     */
    public function getTupleList()
    {
        return $this->tupleList;
    }
    /**
     * Set tupleList value
     * @param \StructType\CoordinatesType $tupleList
     * @return \StructType\DataBlockType
     */
    public function setTupleList(\StructType\CoordinatesType $tupleList = null)
    {
        $this->tupleList = $tupleList;
        return $this;
    }
    /**
     * Get doubleOrNilReasonTupleList value
     * @return list|null
     */
    public function getDoubleOrNilReasonTupleList()
    {
        return $this->doubleOrNilReasonTupleList;
    }
    /**
     * Set doubleOrNilReasonTupleList value
     * @param list $doubleOrNilReasonTupleList
     * @return \StructType\DataBlockType
     */
    public function setDoubleOrNilReasonTupleList(list $doubleOrNilReasonTupleList = null)
    {
        $this->doubleOrNilReasonTupleList = $doubleOrNilReasonTupleList;
        return $this;
    }
}
