<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConeType StructType
 * @subpackage Structs
 */
class ConeType extends AbstractStructBase
{
    /**
     * The horizontalCurveType
     * @var string
     */
    public $horizontalCurveType;
    /**
     * The verticalCurveType
     * @var string
     */
    public $verticalCurveType;
    /**
     * Constructor method for ConeType
     * @uses ConeType::setHorizontalCurveType()
     * @uses ConeType::setVerticalCurveType()
     * @param string $horizontalCurveType
     * @param string $verticalCurveType
     */
    public function __construct($horizontalCurveType = null, $verticalCurveType = null)
    {
        $this
            ->setHorizontalCurveType($horizontalCurveType)
            ->setVerticalCurveType($verticalCurveType);
    }
    /**
     * Get horizontalCurveType value
     * @return string|null
     */
    public function getHorizontalCurveType()
    {
        return $this->horizontalCurveType;
    }
    /**
     * Set horizontalCurveType value
     * @param string $horizontalCurveType
     * @return \StructType\ConeType
     */
    public function setHorizontalCurveType($horizontalCurveType = null)
    {
        // validation for constraint: string
        if (!is_null($horizontalCurveType) && !is_string($horizontalCurveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($horizontalCurveType, true), gettype($horizontalCurveType)), __LINE__);
        }
        $this->horizontalCurveType = $horizontalCurveType;
        return $this;
    }
    /**
     * Get verticalCurveType value
     * @return string|null
     */
    public function getVerticalCurveType()
    {
        return $this->verticalCurveType;
    }
    /**
     * Set verticalCurveType value
     * @param string $verticalCurveType
     * @return \StructType\ConeType
     */
    public function setVerticalCurveType($verticalCurveType = null)
    {
        // validation for constraint: string
        if (!is_null($verticalCurveType) && !is_string($verticalCurveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verticalCurveType, true), gettype($verticalCurveType)), __LINE__);
        }
        $this->verticalCurveType = $verticalCurveType;
        return $this;
    }
}
