<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompoundCRSType StructType
 * @subpackage Structs
 */
class CompoundCRSType extends AbstractStructBase
{
    /**
     * The componentReferenceSystem
     * @var \StructType\SingleCRSPropertyType
     */
    public $componentReferenceSystem;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for CompoundCRSType
     * @uses CompoundCRSType::setComponentReferenceSystem()
     * @uses CompoundCRSType::setAggregationType()
     * @param \StructType\SingleCRSPropertyType $componentReferenceSystem
     * @param string $aggregationType
     */
    public function __construct(\StructType\SingleCRSPropertyType $componentReferenceSystem = null, $aggregationType = null)
    {
        $this
            ->setComponentReferenceSystem($componentReferenceSystem)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get componentReferenceSystem value
     * @return \StructType\SingleCRSPropertyType|null
     */
    public function getComponentReferenceSystem()
    {
        return $this->componentReferenceSystem;
    }
    /**
     * Set componentReferenceSystem value
     * @param \StructType\SingleCRSPropertyType $componentReferenceSystem
     * @return \StructType\CompoundCRSType
     */
    public function setComponentReferenceSystem(\StructType\SingleCRSPropertyType $componentReferenceSystem = null)
    {
        $this->componentReferenceSystem = $componentReferenceSystem;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\CompoundCRSType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
