<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompositeValueType StructType
 * @subpackage Structs
 */
class CompositeValueType extends AbstractStructBase
{
    /**
     * The valueComponent
     * @var \StructType\ValuePropertyType
     */
    public $valueComponent;
    /**
     * The valueComponents
     * @var \StructType\ValueArrayPropertyType
     */
    public $valueComponents;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for CompositeValueType
     * @uses CompositeValueType::setValueComponent()
     * @uses CompositeValueType::setValueComponents()
     * @uses CompositeValueType::setAggregationType()
     * @param \StructType\ValuePropertyType $valueComponent
     * @param \StructType\ValueArrayPropertyType $valueComponents
     * @param string $aggregationType
     */
    public function __construct(\StructType\ValuePropertyType $valueComponent = null, \StructType\ValueArrayPropertyType $valueComponents = null, $aggregationType = null)
    {
        $this
            ->setValueComponent($valueComponent)
            ->setValueComponents($valueComponents)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get valueComponent value
     * @return \StructType\ValuePropertyType|null
     */
    public function getValueComponent()
    {
        return $this->valueComponent;
    }
    /**
     * Set valueComponent value
     * @param \StructType\ValuePropertyType $valueComponent
     * @return \StructType\CompositeValueType
     */
    public function setValueComponent(\StructType\ValuePropertyType $valueComponent = null)
    {
        $this->valueComponent = $valueComponent;
        return $this;
    }
    /**
     * Get valueComponents value
     * @return \StructType\ValueArrayPropertyType|null
     */
    public function getValueComponents()
    {
        return $this->valueComponents;
    }
    /**
     * Set valueComponents value
     * @param \StructType\ValueArrayPropertyType $valueComponents
     * @return \StructType\CompositeValueType
     */
    public function setValueComponents(\StructType\ValueArrayPropertyType $valueComponents = null)
    {
        $this->valueComponents = $valueComponents;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\CompositeValueType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
