<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoundedFeatureType StructType
 * @subpackage Structs
 */
class BoundedFeatureType extends AbstractStructBase
{
    /**
     * The metaDataProperty
     * @var \StructType\MetaDataPropertyType
     */
    public $metaDataProperty;
    /**
     * The description
     * @var \StructType\StringOrRefType
     */
    public $description;
    /**
     * The descriptionReference
     * @var \StructType\ReferenceType
     */
    public $descriptionReference;
    /**
     * The identifier
     * @var \StructType\CodeWithAuthorityType
     */
    public $identifier;
    /**
     * The name
     * @var \StructType\CodeType
     */
    public $name;
    /**
     * The boundedBy
     * @var \StructType\BoundingShapeType
     */
    public $boundedBy;
    /**
     * The location
     * @var \StructType\LocationPropertyType
     */
    public $location;
    /**
     * Constructor method for BoundedFeatureType
     * @uses BoundedFeatureType::setMetaDataProperty()
     * @uses BoundedFeatureType::setDescription()
     * @uses BoundedFeatureType::setDescriptionReference()
     * @uses BoundedFeatureType::setIdentifier()
     * @uses BoundedFeatureType::setName()
     * @uses BoundedFeatureType::setBoundedBy()
     * @uses BoundedFeatureType::setLocation()
     * @param \StructType\MetaDataPropertyType $metaDataProperty
     * @param \StructType\StringOrRefType $description
     * @param \StructType\ReferenceType $descriptionReference
     * @param \StructType\CodeWithAuthorityType $identifier
     * @param \StructType\CodeType $name
     * @param \StructType\BoundingShapeType $boundedBy
     * @param \StructType\LocationPropertyType $location
     */
    public function __construct(\StructType\MetaDataPropertyType $metaDataProperty = null, \StructType\StringOrRefType $description = null, \StructType\ReferenceType $descriptionReference = null, \StructType\CodeWithAuthorityType $identifier = null, \StructType\CodeType $name = null, \StructType\BoundingShapeType $boundedBy = null, \StructType\LocationPropertyType $location = null)
    {
        $this
            ->setMetaDataProperty($metaDataProperty)
            ->setDescription($description)
            ->setDescriptionReference($descriptionReference)
            ->setIdentifier($identifier)
            ->setName($name)
            ->setBoundedBy($boundedBy)
            ->setLocation($location);
    }
    /**
     * Get metaDataProperty value
     * @return \StructType\MetaDataPropertyType|null
     */
    public function getMetaDataProperty()
    {
        return $this->metaDataProperty;
    }
    /**
     * Set metaDataProperty value
     * @param \StructType\MetaDataPropertyType $metaDataProperty
     * @return \StructType\BoundedFeatureType
     */
    public function setMetaDataProperty(\StructType\MetaDataPropertyType $metaDataProperty = null)
    {
        $this->metaDataProperty = $metaDataProperty;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\StringOrRefType|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param \StructType\StringOrRefType $description
     * @return \StructType\BoundedFeatureType
     */
    public function setDescription(\StructType\StringOrRefType $description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get descriptionReference value
     * @return \StructType\ReferenceType|null
     */
    public function getDescriptionReference()
    {
        return $this->descriptionReference;
    }
    /**
     * Set descriptionReference value
     * @param \StructType\ReferenceType $descriptionReference
     * @return \StructType\BoundedFeatureType
     */
    public function setDescriptionReference(\StructType\ReferenceType $descriptionReference = null)
    {
        $this->descriptionReference = $descriptionReference;
        return $this;
    }
    /**
     * Get identifier value
     * @return \StructType\CodeWithAuthorityType|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\CodeWithAuthorityType $identifier
     * @return \StructType\BoundedFeatureType
     */
    public function setIdentifier(\StructType\CodeWithAuthorityType $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\CodeType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\CodeType $name
     * @return \StructType\BoundedFeatureType
     */
    public function setName(\StructType\CodeType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get boundedBy value
     * @return \StructType\BoundingShapeType|null
     */
    public function getBoundedBy()
    {
        return $this->boundedBy;
    }
    /**
     * Set boundedBy value
     * @param \StructType\BoundingShapeType $boundedBy
     * @return \StructType\BoundedFeatureType
     */
    public function setBoundedBy(\StructType\BoundingShapeType $boundedBy = null)
    {
        $this->boundedBy = $boundedBy;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\LocationPropertyType|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\LocationPropertyType $location
     * @return \StructType\BoundedFeatureType
     */
    public function setLocation(\StructType\LocationPropertyType $location = null)
    {
        $this->location = $location;
        return $this;
    }
}
