<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Binary_PropertyType StructType
 * @subpackage Structs
 */
class Binary_PropertyType extends AbstractStructBase
{
    /**
     * The Binary
     * @var \StructType\Binary_Type
     */
    public $Binary;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for Binary_PropertyType
     * @uses Binary_PropertyType::setBinary()
     * @uses Binary_PropertyType::setNilReason()
     * @param \StructType\Binary_Type $binary
     * @param string $nilReason
     */
    public function __construct(\StructType\Binary_Type $binary = null, $nilReason = null)
    {
        $this
            ->setBinary($binary)
            ->setNilReason($nilReason);
    }
    /**
     * Get Binary value
     * @return \StructType\Binary_Type|null
     */
    public function getBinary()
    {
        return $this->Binary;
    }
    /**
     * Set Binary value
     * @param \StructType\Binary_Type $binary
     * @return \StructType\Binary_PropertyType
     */
    public function setBinary(\StructType\Binary_Type $binary = null)
    {
        $this->Binary = $binary;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\Binary_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
