<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuswahlKontaktpersonBasisinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Ergebnis einer Kontaktpersonabfrage. Enthält entweder die Kontaktperson oder die Basisinformationsobjekte zu Kontaktpersonen.
 * @subpackage Structs
 */
class AuswahlKontaktpersonBasisinformation extends AbstractStructBase
{
    /**
     * The kontaktperson
     * Meta information extracted from the WSDL
     * - documentation: Menge von Kontaktpersonen mit Zuordnung zur OE.
     * - choice: kontaktperson | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KontaktpersonErweitert[]
     */
    public $kontaktperson;
    /**
     * The basisinformation
     * Meta information extracted from the WSDL
     * - documentation: Menge von Basisinformationen zu Kontaktpersonen.
     * - choice: kontaktperson | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BasisinformationObjekt[]
     */
    public $basisinformation;
    /**
     * Constructor method for AuswahlKontaktpersonBasisinformation
     * @uses AuswahlKontaktpersonBasisinformation::setKontaktperson()
     * @uses AuswahlKontaktpersonBasisinformation::setBasisinformation()
     * @param \StructType\KontaktpersonErweitert[] $kontaktperson
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     */
    public function __construct(array $kontaktperson = array(), array $basisinformation = array())
    {
        $this
            ->setKontaktperson($kontaktperson)
            ->setBasisinformation($basisinformation);
    }
    /**
     * Get kontaktperson value
     * @return \StructType\KontaktpersonErweitert[]|null
     */
    public function getKontaktperson()
    {
        return isset($this->kontaktperson) ? $this->kontaktperson : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKontaktperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKontaktperson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKontaktpersonForArrayConstraintsFromSetKontaktperson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlKontaktpersonBasisinformationKontaktpersonItem) {
            // validation for constraint: itemType
            if (!$auswahlKontaktpersonBasisinformationKontaktpersonItem instanceof \StructType\KontaktpersonErweitert) {
                $invalidValues[] = is_object($auswahlKontaktpersonBasisinformationKontaktpersonItem) ? get_class($auswahlKontaktpersonBasisinformationKontaktpersonItem) : sprintf('%s(%s)', gettype($auswahlKontaktpersonBasisinformationKontaktpersonItem), var_export($auswahlKontaktpersonBasisinformationKontaktpersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kontaktperson property can only contain items of type \StructType\KontaktpersonErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setKontaktperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKontaktperson method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKontaktpersonForChoiceConstraintsFromSetKontaktperson($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property kontaktperson can\'t be set as the property %s is already set. Only one property must be set among these properties: kontaktperson, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set kontaktperson value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\KontaktpersonErweitert[] $kontaktperson
     * @return \StructType\AuswahlKontaktpersonBasisinformation
     */
    public function setKontaktperson(array $kontaktperson = array())
    {
        // validation for constraint: array
        if ('' !== ($kontaktpersonArrayErrorMessage = self::validateKontaktpersonForArrayConstraintsFromSetKontaktperson($kontaktperson))) {
            throw new \InvalidArgumentException($kontaktpersonArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(kontaktperson, basisinformation)
        if ('' !== ($kontaktpersonChoiceErrorMessage = self::validateKontaktpersonForChoiceConstraintsFromSetKontaktperson($kontaktperson))) {
            throw new \InvalidArgumentException($kontaktpersonChoiceErrorMessage, __LINE__);
        }
        if (is_null($kontaktperson) || (is_array($kontaktperson) && empty($kontaktperson))) {
            unset($this->kontaktperson);
        } else {
            $this->kontaktperson = $kontaktperson;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToKontaktperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToKontaktperson method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToKontaktperson($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property kontaktperson can\'t be set as the property %s is already set. Only one property must be set among these properties: kontaktperson, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to kontaktperson value
     * @throws \InvalidArgumentException
     * @param \StructType\KontaktpersonErweitert $item
     * @return \StructType\AuswahlKontaktpersonBasisinformation
     */
    public function addToKontaktperson(\StructType\KontaktpersonErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KontaktpersonErweitert) {
            throw new \InvalidArgumentException(sprintf('The kontaktperson property can only contain items of type \StructType\KontaktpersonErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(kontaktperson, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToKontaktperson($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->kontaktperson[] = $item;
        return $this;
    }
    /**
     * Get basisinformation value
     * @return \StructType\BasisinformationObjekt[]|null
     */
    public function getBasisinformation()
    {
        return isset($this->basisinformation) ? $this->basisinformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasisinformationForArrayConstraintsFromSetBasisinformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlKontaktpersonBasisinformationBasisinformationItem) {
            // validation for constraint: itemType
            if (!$auswahlKontaktpersonBasisinformationBasisinformationItem instanceof \StructType\BasisinformationObjekt) {
                $invalidValues[] = is_object($auswahlKontaktpersonBasisinformationBasisinformationItem) ? get_class($auswahlKontaktpersonBasisinformationBasisinformationItem) : sprintf('%s(%s)', gettype($auswahlKontaktpersonBasisinformationBasisinformationItem), var_export($auswahlKontaktpersonBasisinformationBasisinformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBasisinformationForChoiceConstraintsFromSetBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'kontaktperson',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set basisinformation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     * @return \StructType\AuswahlKontaktpersonBasisinformation
     */
    public function setBasisinformation(array $basisinformation = array())
    {
        // validation for constraint: array
        if ('' !== ($basisinformationArrayErrorMessage = self::validateBasisinformationForArrayConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(kontaktperson, basisinformation)
        if ('' !== ($basisinformationChoiceErrorMessage = self::validateBasisinformationForChoiceConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationChoiceErrorMessage, __LINE__);
        }
        if (is_null($basisinformation) || (is_array($basisinformation) && empty($basisinformation))) {
            unset($this->basisinformation);
        } else {
            $this->basisinformation = $basisinformation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'kontaktperson',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to basisinformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt $item
     * @return \StructType\AuswahlKontaktpersonBasisinformation
     */
    public function addToBasisinformation(\StructType\BasisinformationObjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BasisinformationObjekt) {
            throw new \InvalidArgumentException(sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(kontaktperson, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBasisinformation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->basisinformation[] = $item;
        return $this;
    }
}
