<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Auskunftshinweismodul StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieses Modul enthält Informationen zur Leistung, die nur für Servicecenter-Agenten, nicht aber für die Öffentlichkeit bestimmt sind.
 * @subpackage Structs
 */
class Auskunftshinweismodul extends Leistungsmodul
{
    /**
     * The inhalt
     * Meta information extracted from the WSDL
     * - documentation: Textinhalt des Auskunftshinweises für Servicecenter-Agenten. Achtung: Diese Angaben sind i.d.R. nicht für die öffentliche Anzeige bestimmt.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $inhalt;
    /**
     * The weiterfuehrenderLink
     * Meta information extracted from the WSDL
     * - documentation: Angabe von weiterführende Links.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $weiterfuehrenderLink;
    /**
     * Constructor method for Auskunftshinweismodul
     * @uses Auskunftshinweismodul::setInhalt()
     * @uses Auskunftshinweismodul::setWeiterfuehrenderLink()
     * @param \StructType\String_Localized[] $inhalt
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     */
    public function __construct(array $inhalt = array(), array $weiterfuehrenderLink = array())
    {
        $this
            ->setInhalt($inhalt)
            ->setWeiterfuehrenderLink($weiterfuehrenderLink);
    }
    /**
     * Get inhalt value
     * @return \StructType\String_Localized[]|null
     */
    public function getInhalt()
    {
        return $this->inhalt;
    }
    /**
     * This method is responsible for validating the values passed to the setInhalt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInhalt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInhaltForArrayConstraintsFromSetInhalt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auskunftshinweismodulInhaltItem) {
            // validation for constraint: itemType
            if (!$auskunftshinweismodulInhaltItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($auskunftshinweismodulInhaltItem) ? get_class($auskunftshinweismodulInhaltItem) : sprintf('%s(%s)', gettype($auskunftshinweismodulInhaltItem), var_export($auskunftshinweismodulInhaltItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inhalt property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inhalt value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $inhalt
     * @return \StructType\Auskunftshinweismodul
     */
    public function setInhalt(array $inhalt = array())
    {
        // validation for constraint: array
        if ('' !== ($inhaltArrayErrorMessage = self::validateInhaltForArrayConstraintsFromSetInhalt($inhalt))) {
            throw new \InvalidArgumentException($inhaltArrayErrorMessage, __LINE__);
        }
        $this->inhalt = $inhalt;
        return $this;
    }
    /**
     * Add item to inhalt value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Auskunftshinweismodul
     */
    public function addToInhalt(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The inhalt property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inhalt[] = $item;
        return $this;
    }
    /**
     * Get weiterfuehrenderLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getWeiterfuehrenderLink()
    {
        return $this->weiterfuehrenderLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWeiterfuehrenderLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeiterfuehrenderLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auskunftshinweismodulWeiterfuehrenderLinkItem) {
            // validation for constraint: itemType
            if (!$auskunftshinweismodulWeiterfuehrenderLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($auskunftshinweismodulWeiterfuehrenderLinkItem) ? get_class($auskunftshinweismodulWeiterfuehrenderLinkItem) : sprintf('%s(%s)', gettype($auskunftshinweismodulWeiterfuehrenderLinkItem), var_export($auskunftshinweismodulWeiterfuehrenderLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     * @return \StructType\Auskunftshinweismodul
     */
    public function setWeiterfuehrenderLink(array $weiterfuehrenderLink = array())
    {
        // validation for constraint: array
        if ('' !== ($weiterfuehrenderLinkArrayErrorMessage = self::validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink($weiterfuehrenderLink))) {
            throw new \InvalidArgumentException($weiterfuehrenderLinkArrayErrorMessage, __LINE__);
        }
        $this->weiterfuehrenderLink = $weiterfuehrenderLink;
        return $this;
    }
    /**
     * Add item to weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Auskunftshinweismodul
     */
    public function addToWeiterfuehrenderLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weiterfuehrenderLink[] = $item;
        return $this;
    }
}
