<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrayAssociationType StructType
 * @subpackage Structs
 */
class ArrayAssociationType extends AbstractStructBase
{
    /**
     * The AbstractObject
     * @var mixed
     */
    public $AbstractObject;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for ArrayAssociationType
     * @uses ArrayAssociationType::setAbstractObject()
     * @uses ArrayAssociationType::setOwns()
     * @param mixed $abstractObject
     * @param bool $owns
     */
    public function __construct($abstractObject = null, $owns = null)
    {
        $this
            ->setAbstractObject($abstractObject)
            ->setOwns($owns);
    }
    /**
     * Get AbstractObject value
     * @return mixed|null
     */
    public function getAbstractObject()
    {
        return $this->AbstractObject;
    }
    /**
     * Set AbstractObject value
     * @param mixed $abstractObject
     * @return \StructType\ArrayAssociationType
     */
    public function setAbstractObject($abstractObject = null)
    {
        $this->AbstractObject = $abstractObject;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\ArrayAssociationType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
