<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArcStringType StructType
 * @subpackage Structs
 */
class ArcStringType extends AbstractStructBase
{
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The pointProperty
     * @var \StructType\PointPropertyType
     */
    public $pointProperty;
    /**
     * The pointRep
     * @var \StructType\PointPropertyType
     */
    public $pointRep;
    /**
     * The posList
     * @var \StructType\DirectPositionListType
     */
    public $posList;
    /**
     * The coordinates
     * @var \StructType\CoordinatesType
     */
    public $coordinates;
    /**
     * The interpolation
     * @var string
     */
    public $interpolation;
    /**
     * The numArc
     * @var int
     */
    public $numArc;
    /**
     * Constructor method for ArcStringType
     * @uses ArcStringType::setPos()
     * @uses ArcStringType::setPointProperty()
     * @uses ArcStringType::setPointRep()
     * @uses ArcStringType::setPosList()
     * @uses ArcStringType::setCoordinates()
     * @uses ArcStringType::setInterpolation()
     * @uses ArcStringType::setNumArc()
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\PointPropertyType $pointProperty
     * @param \StructType\PointPropertyType $pointRep
     * @param \StructType\DirectPositionListType $posList
     * @param \StructType\CoordinatesType $coordinates
     * @param string $interpolation
     * @param int $numArc
     */
    public function __construct(\StructType\DirectPositionType $pos = null, \StructType\PointPropertyType $pointProperty = null, \StructType\PointPropertyType $pointRep = null, \StructType\DirectPositionListType $posList = null, \StructType\CoordinatesType $coordinates = null, $interpolation = null, $numArc = null)
    {
        $this
            ->setPos($pos)
            ->setPointProperty($pointProperty)
            ->setPointRep($pointRep)
            ->setPosList($posList)
            ->setCoordinates($coordinates)
            ->setInterpolation($interpolation)
            ->setNumArc($numArc);
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\ArcStringType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get pointProperty value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointProperty()
    {
        return $this->pointProperty;
    }
    /**
     * Set pointProperty value
     * @param \StructType\PointPropertyType $pointProperty
     * @return \StructType\ArcStringType
     */
    public function setPointProperty(\StructType\PointPropertyType $pointProperty = null)
    {
        $this->pointProperty = $pointProperty;
        return $this;
    }
    /**
     * Get pointRep value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointRep()
    {
        return $this->pointRep;
    }
    /**
     * Set pointRep value
     * @param \StructType\PointPropertyType $pointRep
     * @return \StructType\ArcStringType
     */
    public function setPointRep(\StructType\PointPropertyType $pointRep = null)
    {
        $this->pointRep = $pointRep;
        return $this;
    }
    /**
     * Get posList value
     * @return \StructType\DirectPositionListType|null
     */
    public function getPosList()
    {
        return $this->posList;
    }
    /**
     * Set posList value
     * @param \StructType\DirectPositionListType $posList
     * @return \StructType\ArcStringType
     */
    public function setPosList(\StructType\DirectPositionListType $posList = null)
    {
        $this->posList = $posList;
        return $this;
    }
    /**
     * Get coordinates value
     * @return \StructType\CoordinatesType|null
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }
    /**
     * Set coordinates value
     * @param \StructType\CoordinatesType $coordinates
     * @return \StructType\ArcStringType
     */
    public function setCoordinates(\StructType\CoordinatesType $coordinates = null)
    {
        $this->coordinates = $coordinates;
        return $this;
    }
    /**
     * Get interpolation value
     * @return string|null
     */
    public function getInterpolation()
    {
        return $this->interpolation;
    }
    /**
     * Set interpolation value
     * @param string $interpolation
     * @return \StructType\ArcStringType
     */
    public function setInterpolation($interpolation = null)
    {
        // validation for constraint: string
        if (!is_null($interpolation) && !is_string($interpolation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interpolation, true), gettype($interpolation)), __LINE__);
        }
        $this->interpolation = $interpolation;
        return $this;
    }
    /**
     * Get numArc value
     * @return int|null
     */
    public function getNumArc()
    {
        return $this->numArc;
    }
    /**
     * Set numArc value
     * @param int $numArc
     * @return \StructType\ArcStringType
     */
    public function setNumArc($numArc = null)
    {
        // validation for constraint: int
        if (!is_null($numArc) && !(is_int($numArc) || ctype_digit($numArc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numArc, true), gettype($numArc)), __LINE__);
        }
        $this->numArc = $numArc;
        return $this;
    }
}
