<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortSpezialisierung StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Spezialisierungsanfrage.
 * @subpackage Structs
 */
class AntwortSpezialisierung extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageSpezialisierung
     */
    public $anfrage;
    /**
     * The ergebnisSpezialisierung
     * Meta information extracted from the WSDL
     * - documentation: Das oder die Ergebnisse zur Anfrage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LeistungSpezialisierung[]
     */
    public $ergebnisSpezialisierung;
    /**
     * Constructor method for AntwortSpezialisierung
     * @uses AntwortSpezialisierung::setAnfrage()
     * @uses AntwortSpezialisierung::setErgebnisSpezialisierung()
     * @param \StructType\AnfrageSpezialisierung $anfrage
     * @param \StructType\LeistungSpezialisierung[] $ergebnisSpezialisierung
     */
    public function __construct(\StructType\AnfrageSpezialisierung $anfrage = null, array $ergebnisSpezialisierung = array())
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnisSpezialisierung($ergebnisSpezialisierung);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageSpezialisierung|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageSpezialisierung $anfrage
     * @return \StructType\AntwortSpezialisierung
     */
    public function setAnfrage(\StructType\AnfrageSpezialisierung $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnisSpezialisierung value
     * @return \StructType\LeistungSpezialisierung[]|null
     */
    public function getErgebnisSpezialisierung()
    {
        return $this->ergebnisSpezialisierung;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisSpezialisierung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisSpezialisierung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisSpezialisierungForArrayConstraintsFromSetErgebnisSpezialisierung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortSpezialisierungErgebnisSpezialisierungItem) {
            // validation for constraint: itemType
            if (!$antwortSpezialisierungErgebnisSpezialisierungItem instanceof \StructType\LeistungSpezialisierung) {
                $invalidValues[] = is_object($antwortSpezialisierungErgebnisSpezialisierungItem) ? get_class($antwortSpezialisierungErgebnisSpezialisierungItem) : sprintf('%s(%s)', gettype($antwortSpezialisierungErgebnisSpezialisierungItem), var_export($antwortSpezialisierungErgebnisSpezialisierungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisSpezialisierung property can only contain items of type \StructType\LeistungSpezialisierung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisSpezialisierung value
     * @throws \InvalidArgumentException
     * @param \StructType\LeistungSpezialisierung[] $ergebnisSpezialisierung
     * @return \StructType\AntwortSpezialisierung
     */
    public function setErgebnisSpezialisierung(array $ergebnisSpezialisierung = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisSpezialisierungArrayErrorMessage = self::validateErgebnisSpezialisierungForArrayConstraintsFromSetErgebnisSpezialisierung($ergebnisSpezialisierung))) {
            throw new \InvalidArgumentException($ergebnisSpezialisierungArrayErrorMessage, __LINE__);
        }
        $this->ergebnisSpezialisierung = $ergebnisSpezialisierung;
        return $this;
    }
    /**
     * Add item to ergebnisSpezialisierung value
     * @throws \InvalidArgumentException
     * @param \StructType\LeistungSpezialisierung $item
     * @return \StructType\AntwortSpezialisierung
     */
    public function addToErgebnisSpezialisierung(\StructType\LeistungSpezialisierung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LeistungSpezialisierung) {
            throw new \InvalidArgumentException(sprintf('The ergebnisSpezialisierung property can only contain items of type \StructType\LeistungSpezialisierung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisSpezialisierung[] = $item;
        return $this;
    }
}
