<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortLeistungskategorie StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Leistungskategorieanfrage.
 * @subpackage Structs
 */
class AntwortLeistungskategorie extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageLeistungskategorie
     */
    public $anfrage;
    /**
     * The ergebnisLeistungskategorie
     * Meta information extracted from the WSDL
     * - documentation: Ergebnis der Anfrage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Leistungskategorie[]
     */
    public $ergebnisLeistungskategorie;
    /**
     * Constructor method for AntwortLeistungskategorie
     * @uses AntwortLeistungskategorie::setAnfrage()
     * @uses AntwortLeistungskategorie::setErgebnisLeistungskategorie()
     * @param \StructType\AnfrageLeistungskategorie $anfrage
     * @param \StructType\Leistungskategorie[] $ergebnisLeistungskategorie
     */
    public function __construct(\StructType\AnfrageLeistungskategorie $anfrage = null, array $ergebnisLeistungskategorie = array())
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnisLeistungskategorie($ergebnisLeistungskategorie);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageLeistungskategorie|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageLeistungskategorie $anfrage
     * @return \StructType\AntwortLeistungskategorie
     */
    public function setAnfrage(\StructType\AnfrageLeistungskategorie $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnisLeistungskategorie value
     * @return \StructType\Leistungskategorie[]|null
     */
    public function getErgebnisLeistungskategorie()
    {
        return $this->ergebnisLeistungskategorie;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisLeistungskategorie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisLeistungskategorie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisLeistungskategorieForArrayConstraintsFromSetErgebnisLeistungskategorie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortLeistungskategorieErgebnisLeistungskategorieItem) {
            // validation for constraint: itemType
            if (!$antwortLeistungskategorieErgebnisLeistungskategorieItem instanceof \StructType\Leistungskategorie) {
                $invalidValues[] = is_object($antwortLeistungskategorieErgebnisLeistungskategorieItem) ? get_class($antwortLeistungskategorieErgebnisLeistungskategorieItem) : sprintf('%s(%s)', gettype($antwortLeistungskategorieErgebnisLeistungskategorieItem), var_export($antwortLeistungskategorieErgebnisLeistungskategorieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisLeistungskategorie property can only contain items of type \StructType\Leistungskategorie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisLeistungskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\Leistungskategorie[] $ergebnisLeistungskategorie
     * @return \StructType\AntwortLeistungskategorie
     */
    public function setErgebnisLeistungskategorie(array $ergebnisLeistungskategorie = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisLeistungskategorieArrayErrorMessage = self::validateErgebnisLeistungskategorieForArrayConstraintsFromSetErgebnisLeistungskategorie($ergebnisLeistungskategorie))) {
            throw new \InvalidArgumentException($ergebnisLeistungskategorieArrayErrorMessage, __LINE__);
        }
        $this->ergebnisLeistungskategorie = $ergebnisLeistungskategorie;
        return $this;
    }
    /**
     * Add item to ergebnisLeistungskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\Leistungskategorie $item
     * @return \StructType\AntwortLeistungskategorie
     */
    public function addToErgebnisLeistungskategorie(\StructType\Leistungskategorie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Leistungskategorie) {
            throw new \InvalidArgumentException(sprintf('The ergebnisLeistungskategorie property can only contain items of type \StructType\Leistungskategorie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisLeistungskategorie[] = $item;
        return $this;
    }
}
