<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortGebietstyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Anfrage nach Gebietstypen.
 * @subpackage Structs
 */
class AntwortGebietstyp extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageGebietstyp
     */
    public $anfrage;
    /**
     * The ergebnisGebietstyp
     * Meta information extracted from the WSDL
     * - documentation: Ergebnis der Anfrage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Gebietstyp[]
     */
    public $ergebnisGebietstyp;
    /**
     * Constructor method for AntwortGebietstyp
     * @uses AntwortGebietstyp::setAnfrage()
     * @uses AntwortGebietstyp::setErgebnisGebietstyp()
     * @param \StructType\AnfrageGebietstyp $anfrage
     * @param \StructType\Gebietstyp[] $ergebnisGebietstyp
     */
    public function __construct(\StructType\AnfrageGebietstyp $anfrage = null, array $ergebnisGebietstyp = array())
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnisGebietstyp($ergebnisGebietstyp);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageGebietstyp|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageGebietstyp $anfrage
     * @return \StructType\AntwortGebietstyp
     */
    public function setAnfrage(\StructType\AnfrageGebietstyp $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnisGebietstyp value
     * @return \StructType\Gebietstyp[]|null
     */
    public function getErgebnisGebietstyp()
    {
        return $this->ergebnisGebietstyp;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisGebietstyp method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisGebietstyp method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisGebietstypForArrayConstraintsFromSetErgebnisGebietstyp(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortGebietstypErgebnisGebietstypItem) {
            // validation for constraint: itemType
            if (!$antwortGebietstypErgebnisGebietstypItem instanceof \StructType\Gebietstyp) {
                $invalidValues[] = is_object($antwortGebietstypErgebnisGebietstypItem) ? get_class($antwortGebietstypErgebnisGebietstypItem) : sprintf('%s(%s)', gettype($antwortGebietstypErgebnisGebietstypItem), var_export($antwortGebietstypErgebnisGebietstypItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisGebietstyp property can only contain items of type \StructType\Gebietstyp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisGebietstyp value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebietstyp[] $ergebnisGebietstyp
     * @return \StructType\AntwortGebietstyp
     */
    public function setErgebnisGebietstyp(array $ergebnisGebietstyp = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisGebietstypArrayErrorMessage = self::validateErgebnisGebietstypForArrayConstraintsFromSetErgebnisGebietstyp($ergebnisGebietstyp))) {
            throw new \InvalidArgumentException($ergebnisGebietstypArrayErrorMessage, __LINE__);
        }
        $this->ergebnisGebietstyp = $ergebnisGebietstyp;
        return $this;
    }
    /**
     * Add item to ergebnisGebietstyp value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebietstyp $item
     * @return \StructType\AntwortGebietstyp
     */
    public function addToErgebnisGebietstyp(\StructType\Gebietstyp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Gebietstyp) {
            throw new \InvalidArgumentException(sprintf('The ergebnisGebietstyp property can only contain items of type \StructType\Gebietstyp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisGebietstyp[] = $item;
        return $this;
    }
}
