<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortGebiet StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort für Gebiete.
 * @subpackage Structs
 */
class AntwortGebiet extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageGebiet
     */
    public $anfrage;
    /**
     * The ergebnis
     * Meta information extracted from the WSDL
     * - documentation: Die Gebiete als Ergebnis. Je nach Wahl im Suchprofil als Gebiete oder Basisinformation.
     * - minOccurs: 0
     * @var \StructType\AuswahlGebietBasisinformation
     */
    public $ergebnis;
    /**
     * Constructor method for AntwortGebiet
     * @uses AntwortGebiet::setAnfrage()
     * @uses AntwortGebiet::setErgebnis()
     * @param \StructType\AnfrageGebiet $anfrage
     * @param \StructType\AuswahlGebietBasisinformation $ergebnis
     */
    public function __construct(\StructType\AnfrageGebiet $anfrage = null, \StructType\AuswahlGebietBasisinformation $ergebnis = null)
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnis($ergebnis);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageGebiet|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageGebiet $anfrage
     * @return \StructType\AntwortGebiet
     */
    public function setAnfrage(\StructType\AnfrageGebiet $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnis value
     * @return \StructType\AuswahlGebietBasisinformation|null
     */
    public function getErgebnis()
    {
        return $this->ergebnis;
    }
    /**
     * Set ergebnis value
     * @param \StructType\AuswahlGebietBasisinformation $ergebnis
     * @return \StructType\AntwortGebiet
     */
    public function setErgebnis(\StructType\AuswahlGebietBasisinformation $ergebnis = null)
    {
        $this->ergebnis = $ergebnis;
        return $this;
    }
}
