<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractCoordinateOperationType StructType
 * @subpackage Structs
 */
class AbstractCoordinateOperationType extends AbstractStructBase
{
    /**
     * The domainOfValidity
     * @var \StructType\DomainOfValidity
     */
    public $domainOfValidity;
    /**
     * The scope
     * @var string
     */
    public $scope;
    /**
     * The operationVersion
     * @var string
     */
    public $operationVersion;
    /**
     * The coordinateOperationAccuracy
     * @var \StructType\CoordinateOperationAccuracy
     */
    public $coordinateOperationAccuracy;
    /**
     * The sourceCRS
     * @var \StructType\CRSPropertyType
     */
    public $sourceCRS;
    /**
     * The targetCRS
     * @var \StructType\CRSPropertyType
     */
    public $targetCRS;
    /**
     * Constructor method for AbstractCoordinateOperationType
     * @uses AbstractCoordinateOperationType::setDomainOfValidity()
     * @uses AbstractCoordinateOperationType::setScope()
     * @uses AbstractCoordinateOperationType::setOperationVersion()
     * @uses AbstractCoordinateOperationType::setCoordinateOperationAccuracy()
     * @uses AbstractCoordinateOperationType::setSourceCRS()
     * @uses AbstractCoordinateOperationType::setTargetCRS()
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @param string $scope
     * @param string $operationVersion
     * @param \StructType\CoordinateOperationAccuracy $coordinateOperationAccuracy
     * @param \StructType\CRSPropertyType $sourceCRS
     * @param \StructType\CRSPropertyType $targetCRS
     */
    public function __construct(\StructType\DomainOfValidity $domainOfValidity = null, $scope = null, $operationVersion = null, \StructType\CoordinateOperationAccuracy $coordinateOperationAccuracy = null, \StructType\CRSPropertyType $sourceCRS = null, \StructType\CRSPropertyType $targetCRS = null)
    {
        $this
            ->setDomainOfValidity($domainOfValidity)
            ->setScope($scope)
            ->setOperationVersion($operationVersion)
            ->setCoordinateOperationAccuracy($coordinateOperationAccuracy)
            ->setSourceCRS($sourceCRS)
            ->setTargetCRS($targetCRS);
    }
    /**
     * Get domainOfValidity value
     * @return \StructType\DomainOfValidity|null
     */
    public function getDomainOfValidity()
    {
        return $this->domainOfValidity;
    }
    /**
     * Set domainOfValidity value
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @return \StructType\AbstractCoordinateOperationType
     */
    public function setDomainOfValidity(\StructType\DomainOfValidity $domainOfValidity = null)
    {
        $this->domainOfValidity = $domainOfValidity;
        return $this;
    }
    /**
     * Get scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * Set scope value
     * @param string $scope
     * @return \StructType\AbstractCoordinateOperationType
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scope, true), gettype($scope)), __LINE__);
        }
        $this->scope = $scope;
        return $this;
    }
    /**
     * Get operationVersion value
     * @return string|null
     */
    public function getOperationVersion()
    {
        return $this->operationVersion;
    }
    /**
     * Set operationVersion value
     * @param string $operationVersion
     * @return \StructType\AbstractCoordinateOperationType
     */
    public function setOperationVersion($operationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($operationVersion) && !is_string($operationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationVersion, true), gettype($operationVersion)), __LINE__);
        }
        $this->operationVersion = $operationVersion;
        return $this;
    }
    /**
     * Get coordinateOperationAccuracy value
     * @return \StructType\CoordinateOperationAccuracy|null
     */
    public function getCoordinateOperationAccuracy()
    {
        return $this->coordinateOperationAccuracy;
    }
    /**
     * Set coordinateOperationAccuracy value
     * @param \StructType\CoordinateOperationAccuracy $coordinateOperationAccuracy
     * @return \StructType\AbstractCoordinateOperationType
     */
    public function setCoordinateOperationAccuracy(\StructType\CoordinateOperationAccuracy $coordinateOperationAccuracy = null)
    {
        $this->coordinateOperationAccuracy = $coordinateOperationAccuracy;
        return $this;
    }
    /**
     * Get sourceCRS value
     * @return \StructType\CRSPropertyType|null
     */
    public function getSourceCRS()
    {
        return $this->sourceCRS;
    }
    /**
     * Set sourceCRS value
     * @param \StructType\CRSPropertyType $sourceCRS
     * @return \StructType\AbstractCoordinateOperationType
     */
    public function setSourceCRS(\StructType\CRSPropertyType $sourceCRS = null)
    {
        $this->sourceCRS = $sourceCRS;
        return $this;
    }
    /**
     * Get targetCRS value
     * @return \StructType\CRSPropertyType|null
     */
    public function getTargetCRS()
    {
        return $this->targetCRS;
    }
    /**
     * Set targetCRS value
     * @param \StructType\CRSPropertyType $targetCRS
     * @return \StructType\AbstractCoordinateOperationType
     */
    public function setTargetCRS(\StructType\CRSPropertyType $targetCRS = null)
    {
        $this->targetCRS = $targetCRS;
        return $this;
    }
}
