<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractCRSType StructType
 * @subpackage Structs
 */
class AbstractCRSType extends AbstractStructBase
{
    /**
     * The domainOfValidity
     * @var \StructType\DomainOfValidity
     */
    public $domainOfValidity;
    /**
     * The scope
     * @var string
     */
    public $scope;
    /**
     * Constructor method for AbstractCRSType
     * @uses AbstractCRSType::setDomainOfValidity()
     * @uses AbstractCRSType::setScope()
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @param string $scope
     */
    public function __construct(\StructType\DomainOfValidity $domainOfValidity = null, $scope = null)
    {
        $this
            ->setDomainOfValidity($domainOfValidity)
            ->setScope($scope);
    }
    /**
     * Get domainOfValidity value
     * @return \StructType\DomainOfValidity|null
     */
    public function getDomainOfValidity()
    {
        return $this->domainOfValidity;
    }
    /**
     * Set domainOfValidity value
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @return \StructType\AbstractCRSType
     */
    public function setDomainOfValidity(\StructType\DomainOfValidity $domainOfValidity = null)
    {
        $this->domainOfValidity = $domainOfValidity;
        return $this;
    }
    /**
     * Get scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * Set scope value
     * @param string $scope
     * @return \StructType\AbstractCRSType
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scope, true), gettype($scope)), __LINE__);
        }
        $this->scope = $scope;
        return $this;
    }
}
