<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayType ArrayType
 * @subpackage Arrays
 */
class ArrayType extends AbstractStructArrayBase
{
    /**
     * The members
     * @var \StructType\ArrayAssociationType
     */
    public $members;
    /**
     * Constructor method for ArrayType
     * @uses ArrayType::setMembers()
     * @param \StructType\ArrayAssociationType $members
     */
    public function __construct(\StructType\ArrayAssociationType $members = null)
    {
        $this
            ->setMembers($members);
    }
    /**
     * Get members value
     * @return \StructType\ArrayAssociationType|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\ArrayAssociationType $members
     * @return \ArrayType\ArrayType
     */
    public function setMembers(\StructType\ArrayAssociationType $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ArrayAssociationType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ArrayAssociationType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ArrayAssociationType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ArrayAssociationType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ArrayAssociationType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string members
     */
    public function getAttributeName()
    {
        return 'members';
    }
}
