<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for validateEORI StructType
 * Meta information extracted from the WSDL
 * - type: ns0:validateEORI
 * @subpackage Structs
 */
class ValidateEORI extends AbstractStructBase
{
    /**
     * The eori
     * Meta information extracted from the WSDL
     * - documentation: Single line string: Avoid presence of \n (new line) and \r (return) characters in thestring. Note that pattern ".*" is equivalent. | EORI Number format
     * - base: SingleLineString
     * - form: qualified
     * - maxLength: 17
     * - maxOccurs: unbounded
     * - minLength: 3
     * - minOccurs: 0
     * - pattern: [A-Z]{2}\p{IsBasicLatin}+
     * @var string[]
     */
    public $eori;
    /**
     * Constructor method for validateEORI
     * @uses ValidateEORI::setEori()
     * @param string[] $eori
     */
    public function __construct(array $eori = array())
    {
        $this
            ->setEori($eori);
    }
    /**
     * Get eori value
     * @return string[]|null
     */
    public function getEori()
    {
        return $this->eori;
    }
    /**
     * Set eori value
     * @param string[] $eori
     * @return ValidateEORI
     */
    public function setEori(array $eori = array())
    {
        $this->eori = $eori;
        return $this;
    }
    /**
     * Add item to eori value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return ValidateEORI
     */
    public function addToEori($item)
    {
        $this->eori[] = $item;
        return $this;
    }
}
