<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The street_number
     * @var mixed
     */
    public $street_number;
    /**
     * The city
     * @var mixed
     */
    public $city;
    /**
     * The country_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $country_code;
    /**
     * The country_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $country_name;
    /**
     * The postal_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $postal_code;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $name;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $email;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $fax;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $phone;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setStreet_number()
     * @uses AddressType::setCity()
     * @uses AddressType::setCountry_code()
     * @uses AddressType::setCountry_name()
     * @uses AddressType::setPostal_code()
     * @uses AddressType::setName()
     * @uses AddressType::setEmail()
     * @uses AddressType::setFax()
     * @uses AddressType::setPhone()
     * @param mixed $street_number
     * @param mixed $city
     * @param mixed $country_code
     * @param mixed $country_name
     * @param mixed $postal_code
     * @param mixed $name
     * @param mixed $email
     * @param mixed $fax
     * @param mixed $phone
     */
    public function __construct($street_number = null, $city = null, $country_code = null, $country_name = null, $postal_code = null, $name = null, $email = null, $fax = null, $phone = null)
    {
        $this
            ->setStreet_number($street_number)
            ->setCity($city)
            ->setCountry_code($country_code)
            ->setCountry_name($country_name)
            ->setPostal_code($postal_code)
            ->setName($name)
            ->setEmail($email)
            ->setFax($fax)
            ->setPhone($phone);
    }
    /**
     * Get street_number value
     * @return mixed|null
     */
    public function getStreet_number()
    {
        return $this->{'street.number'};
    }
    /**
     * Set street_number value
     * @param mixed $street_number
     * @return AddressType
     */
    public function setStreet_number($street_number = null)
    {
        $this->street_number = $this->{'street.number'} = $street_number;
        return $this;
    }
    /**
     * Get city value
     * @return mixed|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param mixed $city
     * @return AddressType
     */
    public function setCity($city = null)
    {
        $this->city = $city;
        return $this;
    }
    /**
     * Get country_code value
     * @return mixed|null
     */
    public function getCountry_code()
    {
        return $this->{'country.code'};
    }
    /**
     * Set country_code value
     * @param mixed $country_code
     * @return AddressType
     */
    public function setCountry_code($country_code = null)
    {
        $this->country_code = $this->{'country.code'} = $country_code;
        return $this;
    }
    /**
     * Get country_name value
     * @return mixed|null
     */
    public function getCountry_name()
    {
        return $this->{'country.name'};
    }
    /**
     * Set country_name value
     * @param mixed $country_name
     * @return AddressType
     */
    public function setCountry_name($country_name = null)
    {
        $this->country_name = $this->{'country.name'} = $country_name;
        return $this;
    }
    /**
     * Get postal_code value
     * @return mixed|null
     */
    public function getPostal_code()
    {
        return $this->{'postal.code'};
    }
    /**
     * Set postal_code value
     * @param mixed $postal_code
     * @return AddressType
     */
    public function setPostal_code($postal_code = null)
    {
        $this->postal_code = $this->{'postal.code'} = $postal_code;
        return $this;
    }
    /**
     * Get name value
     * @return mixed|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param mixed $name
     * @return AddressType
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get email value
     * @return mixed|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param mixed $email
     * @return AddressType
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Get fax value
     * @return mixed|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param mixed $fax
     * @return AddressType
     */
    public function setFax($fax = null)
    {
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get phone value
     * @return mixed|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param mixed $phone
     * @return AddressType
     */
    public function setPhone($phone = null)
    {
        $this->phone = $phone;
        return $this;
    }
}
