<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eoriValidationResult StructType
 * @subpackage Structs
 */
class EoriValidationResult extends AbstractStructBase
{
    /**
     * The requestDate
     * @var string
     */
    public $requestDate;
    /**
     * The errorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorDescription;
    /**
     * The result
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var EoriResponse[]
     */
    public $result;
    /**
     * Constructor method for eoriValidationResult
     * @uses EoriValidationResult::setRequestDate()
     * @uses EoriValidationResult::setErrorDescription()
     * @uses EoriValidationResult::setResult()
     * @param string $requestDate
     * @param string $errorDescription
     * @param EoriResponse[] $result
     */
    public function __construct($requestDate = null, $errorDescription = null, array $result = array())
    {
        $this
            ->setRequestDate($requestDate)
            ->setErrorDescription($errorDescription)
            ->setResult($result);
    }
    /**
     * Get requestDate value
     * @return string|null
     */
    public function getRequestDate()
    {
        return $this->requestDate;
    }
    /**
     * Set requestDate value
     * @param string $requestDate
     * @return EoriValidationResult
     */
    public function setRequestDate($requestDate = null)
    {
        $this->requestDate = $requestDate;
        return $this;
    }
    /**
     * Get errorDescription value
     * @return string|null
     */
    public function getErrorDescription()
    {
        return $this->errorDescription;
    }
    /**
     * Set errorDescription value
     * @param string $errorDescription
     * @return EoriValidationResult
     */
    public function setErrorDescription($errorDescription = null)
    {
        $this->errorDescription = $errorDescription;
        return $this;
    }
    /**
     * Get result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return EoriResponse[]|null
     */
    public function getResult()
    {
        return isset($this->result) ? $this->result : null;
    }
    /**
     * Set result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param EoriResponse[] $result
     * @return EoriValidationResult
     */
    public function setResult(array $result = array())
    {
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->result);
        } else {
            $this->result = $result;
        }
        return $this;
    }
    /**
     * Add item to result value
     * @throws \InvalidArgumentException
     * @param EoriResponse $item
     * @return EoriValidationResult
     */
    public function addToResult(EoriResponse $item)
    {
        $this->result[] = $item;
        return $this;
    }
}
