<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eoriResponse StructType
 * @subpackage Structs
 */
class EoriResponse extends AbstractStructBase
{
    /**
     * The eori
     * @var string
     */
    public $eori;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The statusDescr
     * @var string
     */
    public $statusDescr;
    /**
     * The errorReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorReason;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * Constructor method for eoriResponse
     * @uses EoriResponse::setEori()
     * @uses EoriResponse::setStatus()
     * @uses EoriResponse::setStatusDescr()
     * @uses EoriResponse::setErrorReason()
     * @uses EoriResponse::setName()
     * @uses EoriResponse::setAddress()
     * @uses EoriResponse::setStreet()
     * @uses EoriResponse::setPostalCode()
     * @uses EoriResponse::setCity()
     * @uses EoriResponse::setCountry()
     * @param string $eori
     * @param int $status
     * @param string $statusDescr
     * @param string $errorReason
     * @param string $name
     * @param string $address
     * @param string $street
     * @param string $postalCode
     * @param string $city
     * @param string $country
     */
    public function __construct($eori = null, $status = null, $statusDescr = null, $errorReason = null, $name = null, $address = null, $street = null, $postalCode = null, $city = null, $country = null)
    {
        $this
            ->setEori($eori)
            ->setStatus($status)
            ->setStatusDescr($statusDescr)
            ->setErrorReason($errorReason)
            ->setName($name)
            ->setAddress($address)
            ->setStreet($street)
            ->setPostalCode($postalCode)
            ->setCity($city)
            ->setCountry($country);
    }
    /**
     * Get eori value
     * @return string|null
     */
    public function getEori()
    {
        return $this->eori;
    }
    /**
     * Set eori value
     * @param string $eori
     * @return EoriResponse
     */
    public function setEori($eori = null)
    {
        $this->eori = $eori;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return EoriResponse
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusDescr value
     * @return string|null
     */
    public function getStatusDescr()
    {
        return $this->statusDescr;
    }
    /**
     * Set statusDescr value
     * @param string $statusDescr
     * @return EoriResponse
     */
    public function setStatusDescr($statusDescr = null)
    {
        $this->statusDescr = $statusDescr;
        return $this;
    }
    /**
     * Get errorReason value
     * @return string|null
     */
    public function getErrorReason()
    {
        return $this->errorReason;
    }
    /**
     * Set errorReason value
     * @param string $errorReason
     * @return EoriResponse
     */
    public function setErrorReason($errorReason = null)
    {
        $this->errorReason = $errorReason;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return EoriResponse
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return EoriResponse
     */
    public function setAddress($address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return EoriResponse
     */
    public function setStreet($street = null)
    {
        $this->street = $street;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return EoriResponse
     */
    public function setPostalCode($postalCode = null)
    {
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return EoriResponse
     */
    public function setCity($city = null)
    {
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return EoriResponse
     */
    public function setCountry($country = null)
    {
        $this->country = $country;
        return $this;
    }
}
