<?php

namespace Scraper\ScraperDPD\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiShipment StructType
 * @subpackage Structs
 */
class MultiShipment extends AbstractStructBase
{
    /**
     * The mastershipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\StructType\Shipment
     */
    public $mastershipment;
    /**
     * The shipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\ArrayType\ArrayOfShipment
     */
    public $shipments;
    /**
     * Constructor method for MultiShipment
     * @uses MultiShipment::setMastershipment()
     * @uses MultiShipment::setShipments()
     * @param \Scraper\ScraperDPD\StructType\Shipment $mastershipment
     * @param \Scraper\ScraperDPD\ArrayType\ArrayOfShipment $shipments
     */
    public function __construct(\Scraper\ScraperDPD\StructType\Shipment $mastershipment = null, \Scraper\ScraperDPD\ArrayType\ArrayOfShipment $shipments = null)
    {
        $this
            ->setMastershipment($mastershipment)
            ->setShipments($shipments);
    }
    /**
     * Get mastershipment value
     * @return \Scraper\ScraperDPD\StructType\Shipment|null
     */
    public function getMastershipment()
    {
        return $this->mastershipment;
    }
    /**
     * Set mastershipment value
     * @param \Scraper\ScraperDPD\StructType\Shipment $mastershipment
     * @return \Scraper\ScraperDPD\StructType\MultiShipment
     */
    public function setMastershipment(\Scraper\ScraperDPD\StructType\Shipment $mastershipment = null)
    {
        $this->mastershipment = $mastershipment;
        return $this;
    }
    /**
     * Get shipments value
     * @return \Scraper\ScraperDPD\ArrayType\ArrayOfShipment|null
     */
    public function getShipments()
    {
        return $this->shipments;
    }
    /**
     * Set shipments value
     * @param \Scraper\ScraperDPD\ArrayType\ArrayOfShipment $shipments
     * @return \Scraper\ScraperDPD\StructType\MultiShipment
     */
    public function setShipments(\Scraper\ScraperDPD\ArrayType\ArrayOfShipment $shipments = null)
    {
        $this->shipments = $shipments;
        return $this;
    }
}
