<?php

namespace Scraper\ScraperDPD\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactCollectionRequest StructType
 * @subpackage Structs
 */
class ContactCollectionRequest extends Contact
{
    /**
     * The shipperNotificationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $shipperNotificationType;
    /**
     * The shipper_email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipper_email;
    /**
     * The shipper_mobil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipper_mobil;
    /**
     * Constructor method for ContactCollectionRequest
     * @uses ContactCollectionRequest::setShipperNotificationType()
     * @uses ContactCollectionRequest::setShipper_email()
     * @uses ContactCollectionRequest::setShipper_mobil()
     * @param string $shipperNotificationType
     * @param string $shipper_email
     * @param string $shipper_mobil
     */
    public function __construct($shipperNotificationType = null, $shipper_email = null, $shipper_mobil = null)
    {
        $this
            ->setShipperNotificationType($shipperNotificationType)
            ->setShipper_email($shipper_email)
            ->setShipper_mobil($shipper_mobil);
    }
    /**
     * Get shipperNotificationType value
     * @return string
     */
    public function getShipperNotificationType()
    {
        return $this->shipperNotificationType;
    }
    /**
     * Set shipperNotificationType value
     * @uses \Scraper\ScraperDPD\EnumType\EtypeShipperContact::valueIsValid()
     * @uses \Scraper\ScraperDPD\EnumType\EtypeShipperContact::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipperNotificationType
     * @return \Scraper\ScraperDPD\StructType\ContactCollectionRequest
     */
    public function setShipperNotificationType($shipperNotificationType = null)
    {
        // validation for constraint: enumeration
        if (!\Scraper\ScraperDPD\EnumType\EtypeShipperContact::valueIsValid($shipperNotificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Scraper\ScraperDPD\EnumType\EtypeShipperContact', is_array($shipperNotificationType) ? implode(', ', $shipperNotificationType) : var_export($shipperNotificationType, true), implode(', ', \Scraper\ScraperDPD\EnumType\EtypeShipperContact::getValidValues())), __LINE__);
        }
        $this->shipperNotificationType = $shipperNotificationType;
        return $this;
    }
    /**
     * Get shipper_email value
     * @return string|null
     */
    public function getShipper_email()
    {
        return $this->shipper_email;
    }
    /**
     * Set shipper_email value
     * @param string $shipper_email
     * @return \Scraper\ScraperDPD\StructType\ContactCollectionRequest
     */
    public function setShipper_email($shipper_email = null)
    {
        // validation for constraint: string
        if (!is_null($shipper_email) && !is_string($shipper_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipper_email, true), gettype($shipper_email)), __LINE__);
        }
        $this->shipper_email = $shipper_email;
        return $this;
    }
    /**
     * Get shipper_mobil value
     * @return string|null
     */
    public function getShipper_mobil()
    {
        return $this->shipper_mobil;
    }
    /**
     * Set shipper_mobil value
     * @param string $shipper_mobil
     * @return \Scraper\ScraperDPD\StructType\ContactCollectionRequest
     */
    public function setShipper_mobil($shipper_mobil = null)
    {
        // validation for constraint: string
        if (!is_null($shipper_mobil) && !is_string($shipper_mobil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipper_mobil, true), gettype($shipper_mobil)), __LINE__);
        }
        $this->shipper_mobil = $shipper_mobil;
        return $this;
    }
}
