<?php

namespace Scraper\ScraperDPD\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentWithLabelsBc StructType
 * @subpackage Structs
 */
class ShipmentWithLabelsBc extends AbstractStructBase
{
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\StructType\ShipmentBc
     */
    public $Shipment;
    /**
     * The Labels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\ArrayType\ArrayOfLabel
     */
    public $Labels;
    /**
     * Constructor method for ShipmentWithLabelsBc
     * @uses ShipmentWithLabelsBc::setShipment()
     * @uses ShipmentWithLabelsBc::setLabels()
     * @param \Scraper\ScraperDPD\StructType\ShipmentBc $shipment
     * @param \Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels
     */
    public function __construct(\Scraper\ScraperDPD\StructType\ShipmentBc $shipment = null, \Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels = null)
    {
        $this
            ->setShipment($shipment)
            ->setLabels($labels);
    }
    /**
     * Get Shipment value
     * @return \Scraper\ScraperDPD\StructType\ShipmentBc|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Scraper\ScraperDPD\StructType\ShipmentBc $shipment
     * @return \Scraper\ScraperDPD\StructType\ShipmentWithLabelsBc
     */
    public function setShipment(\Scraper\ScraperDPD\StructType\ShipmentBc $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get Labels value
     * @return \Scraper\ScraperDPD\ArrayType\ArrayOfLabel|null
     */
    public function getLabels()
    {
        return $this->Labels;
    }
    /**
     * Set Labels value
     * @param \Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels
     * @return \Scraper\ScraperDPD\StructType\ShipmentWithLabelsBc
     */
    public function setLabels(\Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels = null)
    {
        $this->Labels = $labels;
        return $this;
    }
}
