<?php

namespace Scraper\ScraperDPD\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Sets the UserCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Scraper\ScraperDPD\StructType\UserCredentials $userCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserCredentials(\Scraper\ScraperDPD\StructType\UserCredentials $userCredentials, $nameSpace = 'http://www.cargonet.software', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserCredentials', $userCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named isAlive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Scraper\ScraperDPD\StructType\IsAlive $parameters
     * @return \Scraper\ScraperDPD\StructType\IsAliveResponse|bool
     */
    public function isAlive(\Scraper\ScraperDPD\StructType\IsAlive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isAlive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsPickableOnDate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UserCredentials
     * - SOAPHeaderNamespaces: http://www.cargonet.software
     * - SOAPHeaderTypes: \Scraper\ScraperDPD\StructType\UserCredentials
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Scraper\ScraperDPD\StructType\IsPickableOnDate $parameters
     * @return \Scraper\ScraperDPD\StructType\IsPickableOnDateResponse|bool
     */
    public function IsPickableOnDate(\Scraper\ScraperDPD\StructType\IsPickableOnDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsPickableOnDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsDeliverableOnDate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UserCredentials
     * - SOAPHeaderNamespaces: http://www.cargonet.software
     * - SOAPHeaderTypes: \Scraper\ScraperDPD\StructType\UserCredentials
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Scraper\ScraperDPD\StructType\IsDeliverableOnDate $parameters
     * @return \Scraper\ScraperDPD\StructType\IsDeliverableOnDateResponse|bool
     */
    public function IsDeliverableOnDate(\Scraper\ScraperDPD\StructType\IsDeliverableOnDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsDeliverableOnDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsCustomerBlocked
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UserCredentials
     * - SOAPHeaderNamespaces: http://www.cargonet.software
     * - SOAPHeaderTypes: \Scraper\ScraperDPD\StructType\UserCredentials
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Scraper\ScraperDPD\StructType\IsCustomerBlocked $parameters
     * @return \Scraper\ScraperDPD\StructType\IsCustomerBlockedResponse|bool
     */
    public function IsCustomerBlocked(\Scraper\ScraperDPD\StructType\IsCustomerBlocked $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsCustomerBlocked($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Scraper\ScraperDPD\StructType\IsAliveResponse|\Scraper\ScraperDPD\StructType\IsCustomerBlockedResponse|\Scraper\ScraperDPD\StructType\IsDeliverableOnDateResponse|\Scraper\ScraperDPD\StructType\IsPickableOnDateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
