<?php

namespace Scraper\ScraperDPD\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentWithLabels StructType
 * @subpackage Structs
 */
class ShipmentWithLabels extends AbstractStructBase
{
    /**
     * The shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\StructType\Shipment
     */
    public $shipment;
    /**
     * The labels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\ArrayType\ArrayOfLabel
     */
    public $labels;
    /**
     * Constructor method for ShipmentWithLabels
     * @uses ShipmentWithLabels::setShipment()
     * @uses ShipmentWithLabels::setLabels()
     * @param \Scraper\ScraperDPD\StructType\Shipment $shipment
     * @param \Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels
     */
    public function __construct(\Scraper\ScraperDPD\StructType\Shipment $shipment = null, \Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels = null)
    {
        $this
            ->setShipment($shipment)
            ->setLabels($labels);
    }
    /**
     * Get shipment value
     * @return \Scraper\ScraperDPD\StructType\Shipment|null
     */
    public function getShipment()
    {
        return $this->shipment;
    }
    /**
     * Set shipment value
     * @param \Scraper\ScraperDPD\StructType\Shipment $shipment
     * @return \Scraper\ScraperDPD\StructType\ShipmentWithLabels
     */
    public function setShipment(\Scraper\ScraperDPD\StructType\Shipment $shipment = null)
    {
        $this->shipment = $shipment;
        return $this;
    }
    /**
     * Get labels value
     * @return \Scraper\ScraperDPD\ArrayType\ArrayOfLabel|null
     */
    public function getLabels()
    {
        return $this->labels;
    }
    /**
     * Set labels value
     * @param \Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels
     * @return \Scraper\ScraperDPD\StructType\ShipmentWithLabels
     */
    public function setLabels(\Scraper\ScraperDPD\ArrayType\ArrayOfLabel $labels = null)
    {
        $this->labels = $labels;
        return $this;
    }
}
