<?php

namespace Scraper\ScraperDPD\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupAtCustomerRequestBase StructType
 * @subpackage Structs
 */
class PickupAtCustomerRequestBase extends AbstractStructBase
{
    /**
     * The shipperaddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\StructType\Address
     */
    public $shipperaddress;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\StructType\Customer
     */
    public $customer;
    /**
     * The pick_date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pick_date;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Scraper\ScraperDPD\StructType\PickupData
     */
    public $data;
    /**
     * Constructor method for PickupAtCustomerRequestBase
     * @uses PickupAtCustomerRequestBase::setShipperaddress()
     * @uses PickupAtCustomerRequestBase::setCustomer()
     * @uses PickupAtCustomerRequestBase::setPick_date()
     * @uses PickupAtCustomerRequestBase::setData()
     * @param \Scraper\ScraperDPD\StructType\Address $shipperaddress
     * @param \Scraper\ScraperDPD\StructType\Customer $customer
     * @param string $pick_date
     * @param \Scraper\ScraperDPD\StructType\PickupData $data
     */
    public function __construct(\Scraper\ScraperDPD\StructType\Address $shipperaddress = null, \Scraper\ScraperDPD\StructType\Customer $customer = null, $pick_date = null, \Scraper\ScraperDPD\StructType\PickupData $data = null)
    {
        $this
            ->setShipperaddress($shipperaddress)
            ->setCustomer($customer)
            ->setPick_date($pick_date)
            ->setData($data);
    }
    /**
     * Get shipperaddress value
     * @return \Scraper\ScraperDPD\StructType\Address|null
     */
    public function getShipperaddress()
    {
        return $this->shipperaddress;
    }
    /**
     * Set shipperaddress value
     * @param \Scraper\ScraperDPD\StructType\Address $shipperaddress
     * @return \Scraper\ScraperDPD\StructType\PickupAtCustomerRequestBase
     */
    public function setShipperaddress(\Scraper\ScraperDPD\StructType\Address $shipperaddress = null)
    {
        $this->shipperaddress = $shipperaddress;
        return $this;
    }
    /**
     * Get customer value
     * @return \Scraper\ScraperDPD\StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \Scraper\ScraperDPD\StructType\Customer $customer
     * @return \Scraper\ScraperDPD\StructType\PickupAtCustomerRequestBase
     */
    public function setCustomer(\Scraper\ScraperDPD\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get pick_date value
     * @return string|null
     */
    public function getPick_date()
    {
        return $this->pick_date;
    }
    /**
     * Set pick_date value
     * @param string $pick_date
     * @return \Scraper\ScraperDPD\StructType\PickupAtCustomerRequestBase
     */
    public function setPick_date($pick_date = null)
    {
        // validation for constraint: string
        if (!is_null($pick_date) && !is_string($pick_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pick_date, true), gettype($pick_date)), __LINE__);
        }
        $this->pick_date = $pick_date;
        return $this;
    }
    /**
     * Get data value
     * @return \Scraper\ScraperDPD\StructType\PickupData|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \Scraper\ScraperDPD\StructType\PickupData $data
     * @return \Scraper\ScraperDPD\StructType\PickupAtCustomerRequestBase
     */
    public function setData(\Scraper\ScraperDPD\StructType\PickupData $data = null)
    {
        $this->data = $data;
        return $this;
    }
}
