<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UyeSozlesmeBilgisi StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UyeSozlesmeBilgisi
 * @subpackage Structs
 */
class UyeSozlesmeBilgisi extends AbstractStructBase
{
    /**
     * The SozlesmeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SozlesmeId;
    /**
     * The SozlesmeTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SozlesmeTipi;
    /**
     * The SozlesmeTipiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SozlesmeTipiId;
    /**
     * Constructor method for UyeSozlesmeBilgisi
     * @uses UyeSozlesmeBilgisi::setSozlesmeId()
     * @uses UyeSozlesmeBilgisi::setSozlesmeTipi()
     * @uses UyeSozlesmeBilgisi::setSozlesmeTipiId()
     * @param int $sozlesmeId
     * @param string $sozlesmeTipi
     * @param int $sozlesmeTipiId
     */
    public function __construct($sozlesmeId = null, $sozlesmeTipi = null, $sozlesmeTipiId = null)
    {
        $this
            ->setSozlesmeId($sozlesmeId)
            ->setSozlesmeTipi($sozlesmeTipi)
            ->setSozlesmeTipiId($sozlesmeTipiId);
    }
    /**
     * Get SozlesmeId value
     * @return int|null
     */
    public function getSozlesmeId()
    {
        return $this->SozlesmeId;
    }
    /**
     * Set SozlesmeId value
     * @param int $sozlesmeId
     * @return \StructType\UyeSozlesmeBilgisi
     */
    public function setSozlesmeId($sozlesmeId = null)
    {
        // validation for constraint: int
        if (!is_null($sozlesmeId) && !(is_int($sozlesmeId) || ctype_digit($sozlesmeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sozlesmeId, true), gettype($sozlesmeId)), __LINE__);
        }
        $this->SozlesmeId = $sozlesmeId;
        return $this;
    }
    /**
     * Get SozlesmeTipi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSozlesmeTipi()
    {
        return isset($this->SozlesmeTipi) ? $this->SozlesmeTipi : null;
    }
    /**
     * Set SozlesmeTipi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sozlesmeTipi
     * @return \StructType\UyeSozlesmeBilgisi
     */
    public function setSozlesmeTipi($sozlesmeTipi = null)
    {
        // validation for constraint: string
        if (!is_null($sozlesmeTipi) && !is_string($sozlesmeTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sozlesmeTipi, true), gettype($sozlesmeTipi)), __LINE__);
        }
        if (is_null($sozlesmeTipi) || (is_array($sozlesmeTipi) && empty($sozlesmeTipi))) {
            unset($this->SozlesmeTipi);
        } else {
            $this->SozlesmeTipi = $sozlesmeTipi;
        }
        return $this;
    }
    /**
     * Get SozlesmeTipiId value
     * @return int|null
     */
    public function getSozlesmeTipiId()
    {
        return $this->SozlesmeTipiId;
    }
    /**
     * Set SozlesmeTipiId value
     * @param int $sozlesmeTipiId
     * @return \StructType\UyeSozlesmeBilgisi
     */
    public function setSozlesmeTipiId($sozlesmeTipiId = null)
    {
        // validation for constraint: int
        if (!is_null($sozlesmeTipiId) && !(is_int($sozlesmeTipiId) || ctype_digit($sozlesmeTipiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sozlesmeTipiId, true), gettype($sozlesmeTipiId)), __LINE__);
        }
        $this->SozlesmeTipiId = $sozlesmeTipiId;
        return $this;
    }
}
