<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateBakiyeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateBakiyeRequest
 * @subpackage Structs
 */
class UpdateBakiyeRequest extends AbstractStructBase
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Aciklama;
    /**
     * The Bakiye
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Bakiye;
    /**
     * The Bloke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Bloke;
    /**
     * The ParaBirimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParaBirimi;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for UpdateBakiyeRequest
     * @uses UpdateBakiyeRequest::setAciklama()
     * @uses UpdateBakiyeRequest::setBakiye()
     * @uses UpdateBakiyeRequest::setBloke()
     * @uses UpdateBakiyeRequest::setParaBirimi()
     * @uses UpdateBakiyeRequest::setUyeID()
     * @param string $aciklama
     * @param float $bakiye
     * @param int $bloke
     * @param string $paraBirimi
     * @param int $uyeID
     */
    public function __construct($aciklama = null, $bakiye = null, $bloke = null, $paraBirimi = null, $uyeID = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setBakiye($bakiye)
            ->setBloke($bloke)
            ->setParaBirimi($paraBirimi)
            ->setUyeID($uyeID);
    }
    /**
     * Get Aciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAciklama()
    {
        return isset($this->Aciklama) ? $this->Aciklama : null;
    }
    /**
     * Set Aciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aciklama
     * @return \StructType\UpdateBakiyeRequest
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        if (is_null($aciklama) || (is_array($aciklama) && empty($aciklama))) {
            unset($this->Aciklama);
        } else {
            $this->Aciklama = $aciklama;
        }
        return $this;
    }
    /**
     * Get Bakiye value
     * @return float|null
     */
    public function getBakiye()
    {
        return $this->Bakiye;
    }
    /**
     * Set Bakiye value
     * @param float $bakiye
     * @return \StructType\UpdateBakiyeRequest
     */
    public function setBakiye($bakiye = null)
    {
        // validation for constraint: float
        if (!is_null($bakiye) && !(is_float($bakiye) || is_numeric($bakiye))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bakiye, true), gettype($bakiye)), __LINE__);
        }
        $this->Bakiye = $bakiye;
        return $this;
    }
    /**
     * Get Bloke value
     * @return int|null
     */
    public function getBloke()
    {
        return $this->Bloke;
    }
    /**
     * Set Bloke value
     * @param int $bloke
     * @return \StructType\UpdateBakiyeRequest
     */
    public function setBloke($bloke = null)
    {
        // validation for constraint: int
        if (!is_null($bloke) && !(is_int($bloke) || ctype_digit($bloke))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bloke, true), gettype($bloke)), __LINE__);
        }
        $this->Bloke = $bloke;
        return $this;
    }
    /**
     * Get ParaBirimi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParaBirimi()
    {
        return isset($this->ParaBirimi) ? $this->ParaBirimi : null;
    }
    /**
     * Set ParaBirimi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paraBirimi
     * @return \StructType\UpdateBakiyeRequest
     */
    public function setParaBirimi($paraBirimi = null)
    {
        // validation for constraint: string
        if (!is_null($paraBirimi) && !is_string($paraBirimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paraBirimi, true), gettype($paraBirimi)), __LINE__);
        }
        if (is_null($paraBirimi) || (is_array($paraBirimi) && empty($paraBirimi))) {
            unset($this->ParaBirimi);
        } else {
            $this->ParaBirimi = $paraBirimi;
        }
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\UpdateBakiyeRequest
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
}
