<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UyeBakiyeBilgisi StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UyeBakiyeBilgisi
 * @subpackage Structs
 */
class UyeBakiyeBilgisi extends AbstractStructBase
{
    /**
     * The Bakiye
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Bakiye;
    /**
     * The BlokeDurum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BlokeDurum;
    /**
     * The ParaBirimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParaBirimi;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tarih;
    /**
     * Constructor method for UyeBakiyeBilgisi
     * @uses UyeBakiyeBilgisi::setBakiye()
     * @uses UyeBakiyeBilgisi::setBlokeDurum()
     * @uses UyeBakiyeBilgisi::setParaBirimi()
     * @uses UyeBakiyeBilgisi::setTarih()
     * @param float $bakiye
     * @param int $blokeDurum
     * @param string $paraBirimi
     * @param string $tarih
     */
    public function __construct($bakiye = null, $blokeDurum = null, $paraBirimi = null, $tarih = null)
    {
        $this
            ->setBakiye($bakiye)
            ->setBlokeDurum($blokeDurum)
            ->setParaBirimi($paraBirimi)
            ->setTarih($tarih);
    }
    /**
     * Get Bakiye value
     * @return float|null
     */
    public function getBakiye()
    {
        return $this->Bakiye;
    }
    /**
     * Set Bakiye value
     * @param float $bakiye
     * @return \StructType\UyeBakiyeBilgisi
     */
    public function setBakiye($bakiye = null)
    {
        // validation for constraint: float
        if (!is_null($bakiye) && !(is_float($bakiye) || is_numeric($bakiye))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bakiye, true), gettype($bakiye)), __LINE__);
        }
        $this->Bakiye = $bakiye;
        return $this;
    }
    /**
     * Get BlokeDurum value
     * @return int|null
     */
    public function getBlokeDurum()
    {
        return $this->BlokeDurum;
    }
    /**
     * Set BlokeDurum value
     * @param int $blokeDurum
     * @return \StructType\UyeBakiyeBilgisi
     */
    public function setBlokeDurum($blokeDurum = null)
    {
        // validation for constraint: int
        if (!is_null($blokeDurum) && !(is_int($blokeDurum) || ctype_digit($blokeDurum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($blokeDurum, true), gettype($blokeDurum)), __LINE__);
        }
        $this->BlokeDurum = $blokeDurum;
        return $this;
    }
    /**
     * Get ParaBirimi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParaBirimi()
    {
        return isset($this->ParaBirimi) ? $this->ParaBirimi : null;
    }
    /**
     * Set ParaBirimi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paraBirimi
     * @return \StructType\UyeBakiyeBilgisi
     */
    public function setParaBirimi($paraBirimi = null)
    {
        // validation for constraint: string
        if (!is_null($paraBirimi) && !is_string($paraBirimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paraBirimi, true), gettype($paraBirimi)), __LINE__);
        }
        if (is_null($paraBirimi) || (is_array($paraBirimi) && empty($paraBirimi))) {
            unset($this->ParaBirimi);
        } else {
            $this->ParaBirimi = $paraBirimi;
        }
        return $this;
    }
    /**
     * Get Tarih value
     * @return string|null
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\UyeBakiyeBilgisi
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
}
