<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectOdemeBildirimiRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SelectOdemeBildirimiRequest
 * @subpackage Structs
 */
class SelectOdemeBildirimiRequest extends AbstractStructBase
{
    /**
     * The BankaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BankaID;
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemID;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for SelectOdemeBildirimiRequest
     * @uses SelectOdemeBildirimiRequest::setBankaID()
     * @uses SelectOdemeBildirimiRequest::setItemID()
     * @uses SelectOdemeBildirimiRequest::setSiparisID()
     * @uses SelectOdemeBildirimiRequest::setUyeID()
     * @param int $bankaID
     * @param int $itemID
     * @param int $siparisID
     * @param int $uyeID
     */
    public function __construct($bankaID = null, $itemID = null, $siparisID = null, $uyeID = null)
    {
        $this
            ->setBankaID($bankaID)
            ->setItemID($itemID)
            ->setSiparisID($siparisID)
            ->setUyeID($uyeID);
    }
    /**
     * Get BankaID value
     * @return int|null
     */
    public function getBankaID()
    {
        return $this->BankaID;
    }
    /**
     * Set BankaID value
     * @param int $bankaID
     * @return \StructType\SelectOdemeBildirimiRequest
     */
    public function setBankaID($bankaID = null)
    {
        // validation for constraint: int
        if (!is_null($bankaID) && !(is_int($bankaID) || ctype_digit($bankaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankaID, true), gettype($bankaID)), __LINE__);
        }
        $this->BankaID = $bankaID;
        return $this;
    }
    /**
     * Get ItemID value
     * @return int|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\SelectOdemeBildirimiRequest
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\SelectOdemeBildirimiRequest
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\SelectOdemeBildirimiRequest
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
}
