<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KargoIlce StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KargoIlce
 * @subpackage Structs
 */
class KargoIlce extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The ILID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ILID;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * Constructor method for KargoIlce
     * @uses KargoIlce::setID()
     * @uses KargoIlce::setILID()
     * @uses KargoIlce::setTanim()
     * @param int $iD
     * @param int $iLID
     * @param string $tanim
     */
    public function __construct($iD = null, $iLID = null, $tanim = null)
    {
        $this
            ->setID($iD)
            ->setILID($iLID)
            ->setTanim($tanim);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\KargoIlce
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ILID value
     * @return int|null
     */
    public function getILID()
    {
        return $this->ILID;
    }
    /**
     * Set ILID value
     * @param int $iLID
     * @return \StructType\KargoIlce
     */
    public function setILID($iLID = null)
    {
        // validation for constraint: int
        if (!is_null($iLID) && !(is_int($iLID) || ctype_digit($iLID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iLID, true), gettype($iLID)), __LINE__);
        }
        $this->ILID = $iLID;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\KargoIlce
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
}
