<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteWebhook StructType
 * @subpackage Structs
 */
class DeleteWebhook extends AbstractStructBase
{
    /**
     * The UyeKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeKodu;
    /**
     * The webhookId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $webhookId;
    /**
     * Constructor method for DeleteWebhook
     * @uses DeleteWebhook::setUyeKodu()
     * @uses DeleteWebhook::setWebhookId()
     * @param string $uyeKodu
     * @param int $webhookId
     */
    public function __construct($uyeKodu = null, $webhookId = null)
    {
        $this
            ->setUyeKodu($uyeKodu)
            ->setWebhookId($webhookId);
    }
    /**
     * Get UyeKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeKodu()
    {
        return isset($this->UyeKodu) ? $this->UyeKodu : null;
    }
    /**
     * Set UyeKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeKodu
     * @return \StructType\DeleteWebhook
     */
    public function setUyeKodu($uyeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($uyeKodu) && !is_string($uyeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeKodu, true), gettype($uyeKodu)), __LINE__);
        }
        if (is_null($uyeKodu) || (is_array($uyeKodu) && empty($uyeKodu))) {
            unset($this->UyeKodu);
        } else {
            $this->UyeKodu = $uyeKodu;
        }
        return $this;
    }
    /**
     * Get webhookId value
     * @return int|null
     */
    public function getWebhookId()
    {
        return $this->webhookId;
    }
    /**
     * Set webhookId value
     * @param int $webhookId
     * @return \StructType\DeleteWebhook
     */
    public function setWebhookId($webhookId = null)
    {
        // validation for constraint: int
        if (!is_null($webhookId) && !(is_int($webhookId) || ctype_digit($webhookId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($webhookId, true), gettype($webhookId)), __LINE__);
        }
        $this->webhookId = $webhookId;
        return $this;
    }
}
