<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebIadeTalepGuncelleRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebIadeTalepGuncelleRequest
 * @subpackage Structs
 */
class WebIadeTalepGuncelleRequest extends AbstractStructBase
{
    /**
     * The BankaKomisyonuIade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BankaKomisyonuIade;
    /**
     * The IadeKoduOlustur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IadeKoduOlustur;
    /**
     * The IadeTutari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IadeTutari;
    /**
     * The KargoTutariIade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KargoTutariIade;
    /**
     * The KartaIadeYap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KartaIadeYap;
    /**
     * The MailGonder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MailGonder;
    /**
     * The SiparisDurumu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SiparisDurumu;
    /**
     * The SiparisDurumuGuncelle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SiparisDurumuGuncelle;
    /**
     * The SiparisUrunDurum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisUrunDurum;
    /**
     * The Talep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IadeTalepUpdate
     */
    public $Talep;
    /**
     * The UrunleriGuncelle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UrunleriGuncelle;
    /**
     * Constructor method for WebIadeTalepGuncelleRequest
     * @uses WebIadeTalepGuncelleRequest::setBankaKomisyonuIade()
     * @uses WebIadeTalepGuncelleRequest::setIadeKoduOlustur()
     * @uses WebIadeTalepGuncelleRequest::setIadeTutari()
     * @uses WebIadeTalepGuncelleRequest::setKargoTutariIade()
     * @uses WebIadeTalepGuncelleRequest::setKartaIadeYap()
     * @uses WebIadeTalepGuncelleRequest::setMailGonder()
     * @uses WebIadeTalepGuncelleRequest::setSiparisDurumu()
     * @uses WebIadeTalepGuncelleRequest::setSiparisDurumuGuncelle()
     * @uses WebIadeTalepGuncelleRequest::setSiparisUrunDurum()
     * @uses WebIadeTalepGuncelleRequest::setTalep()
     * @uses WebIadeTalepGuncelleRequest::setUrunleriGuncelle()
     * @param bool $bankaKomisyonuIade
     * @param bool $iadeKoduOlustur
     * @param float $iadeTutari
     * @param bool $kargoTutariIade
     * @param bool $kartaIadeYap
     * @param bool $mailGonder
     * @param string $siparisDurumu
     * @param bool $siparisDurumuGuncelle
     * @param int $siparisUrunDurum
     * @param \StructType\IadeTalepUpdate $talep
     * @param bool $urunleriGuncelle
     */
    public function __construct($bankaKomisyonuIade = null, $iadeKoduOlustur = null, $iadeTutari = null, $kargoTutariIade = null, $kartaIadeYap = null, $mailGonder = null, $siparisDurumu = null, $siparisDurumuGuncelle = null, $siparisUrunDurum = null, \StructType\IadeTalepUpdate $talep = null, $urunleriGuncelle = null)
    {
        $this
            ->setBankaKomisyonuIade($bankaKomisyonuIade)
            ->setIadeKoduOlustur($iadeKoduOlustur)
            ->setIadeTutari($iadeTutari)
            ->setKargoTutariIade($kargoTutariIade)
            ->setKartaIadeYap($kartaIadeYap)
            ->setMailGonder($mailGonder)
            ->setSiparisDurumu($siparisDurumu)
            ->setSiparisDurumuGuncelle($siparisDurumuGuncelle)
            ->setSiparisUrunDurum($siparisUrunDurum)
            ->setTalep($talep)
            ->setUrunleriGuncelle($urunleriGuncelle);
    }
    /**
     * Get BankaKomisyonuIade value
     * @return bool|null
     */
    public function getBankaKomisyonuIade()
    {
        return $this->BankaKomisyonuIade;
    }
    /**
     * Set BankaKomisyonuIade value
     * @param bool $bankaKomisyonuIade
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setBankaKomisyonuIade($bankaKomisyonuIade = null)
    {
        // validation for constraint: boolean
        if (!is_null($bankaKomisyonuIade) && !is_bool($bankaKomisyonuIade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bankaKomisyonuIade, true), gettype($bankaKomisyonuIade)), __LINE__);
        }
        $this->BankaKomisyonuIade = $bankaKomisyonuIade;
        return $this;
    }
    /**
     * Get IadeKoduOlustur value
     * @return bool|null
     */
    public function getIadeKoduOlustur()
    {
        return $this->IadeKoduOlustur;
    }
    /**
     * Set IadeKoduOlustur value
     * @param bool $iadeKoduOlustur
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setIadeKoduOlustur($iadeKoduOlustur = null)
    {
        // validation for constraint: boolean
        if (!is_null($iadeKoduOlustur) && !is_bool($iadeKoduOlustur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iadeKoduOlustur, true), gettype($iadeKoduOlustur)), __LINE__);
        }
        $this->IadeKoduOlustur = $iadeKoduOlustur;
        return $this;
    }
    /**
     * Get IadeTutari value
     * @return float|null
     */
    public function getIadeTutari()
    {
        return $this->IadeTutari;
    }
    /**
     * Set IadeTutari value
     * @param float $iadeTutari
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setIadeTutari($iadeTutari = null)
    {
        // validation for constraint: float
        if (!is_null($iadeTutari) && !(is_float($iadeTutari) || is_numeric($iadeTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iadeTutari, true), gettype($iadeTutari)), __LINE__);
        }
        $this->IadeTutari = $iadeTutari;
        return $this;
    }
    /**
     * Get KargoTutariIade value
     * @return bool|null
     */
    public function getKargoTutariIade()
    {
        return $this->KargoTutariIade;
    }
    /**
     * Set KargoTutariIade value
     * @param bool $kargoTutariIade
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setKargoTutariIade($kargoTutariIade = null)
    {
        // validation for constraint: boolean
        if (!is_null($kargoTutariIade) && !is_bool($kargoTutariIade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kargoTutariIade, true), gettype($kargoTutariIade)), __LINE__);
        }
        $this->KargoTutariIade = $kargoTutariIade;
        return $this;
    }
    /**
     * Get KartaIadeYap value
     * @return bool|null
     */
    public function getKartaIadeYap()
    {
        return $this->KartaIadeYap;
    }
    /**
     * Set KartaIadeYap value
     * @param bool $kartaIadeYap
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setKartaIadeYap($kartaIadeYap = null)
    {
        // validation for constraint: boolean
        if (!is_null($kartaIadeYap) && !is_bool($kartaIadeYap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kartaIadeYap, true), gettype($kartaIadeYap)), __LINE__);
        }
        $this->KartaIadeYap = $kartaIadeYap;
        return $this;
    }
    /**
     * Get MailGonder value
     * @return bool|null
     */
    public function getMailGonder()
    {
        return $this->MailGonder;
    }
    /**
     * Set MailGonder value
     * @param bool $mailGonder
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setMailGonder($mailGonder = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailGonder) && !is_bool($mailGonder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mailGonder, true), gettype($mailGonder)), __LINE__);
        }
        $this->MailGonder = $mailGonder;
        return $this;
    }
    /**
     * Get SiparisDurumu value
     * @return string|null
     */
    public function getSiparisDurumu()
    {
        return $this->SiparisDurumu;
    }
    /**
     * Set SiparisDurumu value
     * @uses \EnumType\WebSiparisDurumlari::valueIsValid()
     * @uses \EnumType\WebSiparisDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $siparisDurumu
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setSiparisDurumu($siparisDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebSiparisDurumlari::valueIsValid($siparisDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebSiparisDurumlari', is_array($siparisDurumu) ? implode(', ', $siparisDurumu) : var_export($siparisDurumu, true), implode(', ', \EnumType\WebSiparisDurumlari::getValidValues())), __LINE__);
        }
        $this->SiparisDurumu = $siparisDurumu;
        return $this;
    }
    /**
     * Get SiparisDurumuGuncelle value
     * @return bool|null
     */
    public function getSiparisDurumuGuncelle()
    {
        return $this->SiparisDurumuGuncelle;
    }
    /**
     * Set SiparisDurumuGuncelle value
     * @param bool $siparisDurumuGuncelle
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setSiparisDurumuGuncelle($siparisDurumuGuncelle = null)
    {
        // validation for constraint: boolean
        if (!is_null($siparisDurumuGuncelle) && !is_bool($siparisDurumuGuncelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($siparisDurumuGuncelle, true), gettype($siparisDurumuGuncelle)), __LINE__);
        }
        $this->SiparisDurumuGuncelle = $siparisDurumuGuncelle;
        return $this;
    }
    /**
     * Get SiparisUrunDurum value
     * @return int|null
     */
    public function getSiparisUrunDurum()
    {
        return $this->SiparisUrunDurum;
    }
    /**
     * Set SiparisUrunDurum value
     * @param int $siparisUrunDurum
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setSiparisUrunDurum($siparisUrunDurum = null)
    {
        // validation for constraint: int
        if (!is_null($siparisUrunDurum) && !(is_int($siparisUrunDurum) || ctype_digit($siparisUrunDurum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisUrunDurum, true), gettype($siparisUrunDurum)), __LINE__);
        }
        $this->SiparisUrunDurum = $siparisUrunDurum;
        return $this;
    }
    /**
     * Get Talep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IadeTalepUpdate|null
     */
    public function getTalep()
    {
        return isset($this->Talep) ? $this->Talep : null;
    }
    /**
     * Set Talep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IadeTalepUpdate $talep
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setTalep(\StructType\IadeTalepUpdate $talep = null)
    {
        if (is_null($talep) || (is_array($talep) && empty($talep))) {
            unset($this->Talep);
        } else {
            $this->Talep = $talep;
        }
        return $this;
    }
    /**
     * Get UrunleriGuncelle value
     * @return bool|null
     */
    public function getUrunleriGuncelle()
    {
        return $this->UrunleriGuncelle;
    }
    /**
     * Set UrunleriGuncelle value
     * @param bool $urunleriGuncelle
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setUrunleriGuncelle($urunleriGuncelle = null)
    {
        // validation for constraint: boolean
        if (!is_null($urunleriGuncelle) && !is_bool($urunleriGuncelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($urunleriGuncelle, true), gettype($urunleriGuncelle)), __LINE__);
        }
        $this->UrunleriGuncelle = $urunleriGuncelle;
        return $this;
    }
}
