<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Webhook StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Webhook
 * @subpackage Structs
 */
class Webhook extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IslemTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IslemTipi;
    /**
     * The KullaniciAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KullaniciAdi;
    /**
     * The Sifre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sifre;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for Webhook
     * @uses Webhook::setID()
     * @uses Webhook::setIslemTipi()
     * @uses Webhook::setKullaniciAdi()
     * @uses Webhook::setSifre()
     * @uses Webhook::setUrl()
     * @param int $iD
     * @param string $islemTipi
     * @param string $kullaniciAdi
     * @param string $sifre
     * @param string $url
     */
    public function __construct($iD = null, $islemTipi = null, $kullaniciAdi = null, $sifre = null, $url = null)
    {
        $this
            ->setID($iD)
            ->setIslemTipi($islemTipi)
            ->setKullaniciAdi($kullaniciAdi)
            ->setSifre($sifre)
            ->setUrl($url);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Webhook
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IslemTipi value
     * @return string|null
     */
    public function getIslemTipi()
    {
        return $this->IslemTipi;
    }
    /**
     * Set IslemTipi value
     * @uses \EnumType\WebhookIslem::valueIsValid()
     * @uses \EnumType\WebhookIslem::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $islemTipi
     * @return \StructType\Webhook
     */
    public function setIslemTipi($islemTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebhookIslem::valueIsValid($islemTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebhookIslem', is_array($islemTipi) ? implode(', ', $islemTipi) : var_export($islemTipi, true), implode(', ', \EnumType\WebhookIslem::getValidValues())), __LINE__);
        }
        $this->IslemTipi = $islemTipi;
        return $this;
    }
    /**
     * Get KullaniciAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKullaniciAdi()
    {
        return isset($this->KullaniciAdi) ? $this->KullaniciAdi : null;
    }
    /**
     * Set KullaniciAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kullaniciAdi
     * @return \StructType\Webhook
     */
    public function setKullaniciAdi($kullaniciAdi = null)
    {
        // validation for constraint: string
        if (!is_null($kullaniciAdi) && !is_string($kullaniciAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kullaniciAdi, true), gettype($kullaniciAdi)), __LINE__);
        }
        if (is_null($kullaniciAdi) || (is_array($kullaniciAdi) && empty($kullaniciAdi))) {
            unset($this->KullaniciAdi);
        } else {
            $this->KullaniciAdi = $kullaniciAdi;
        }
        return $this;
    }
    /**
     * Get Sifre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifre()
    {
        return isset($this->Sifre) ? $this->Sifre : null;
    }
    /**
     * Set Sifre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifre
     * @return \StructType\Webhook
     */
    public function setSifre($sifre = null)
    {
        // validation for constraint: string
        if (!is_null($sifre) && !is_string($sifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifre, true), gettype($sifre)), __LINE__);
        }
        if (is_null($sifre) || (is_array($sifre) && empty($sifre))) {
            unset($this->Sifre);
        } else {
            $this->Sifre = $sifre;
        }
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\Webhook
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
