<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebServisSayfalama StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebServisSayfalama
 * @subpackage Structs
 */
class WebServisSayfalama extends AbstractStructBase
{
    /**
     * The KayitSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KayitSayisi;
    /**
     * The SayfaNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SayfaNo;
    /**
     * The SiralamaDegeri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiralamaDegeri;
    /**
     * The SiralamaYonu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiralamaYonu;
    /**
     * Constructor method for WebServisSayfalama
     * @uses WebServisSayfalama::setKayitSayisi()
     * @uses WebServisSayfalama::setSayfaNo()
     * @uses WebServisSayfalama::setSiralamaDegeri()
     * @uses WebServisSayfalama::setSiralamaYonu()
     * @param int $kayitSayisi
     * @param int $sayfaNo
     * @param string $siralamaDegeri
     * @param string $siralamaYonu
     */
    public function __construct($kayitSayisi = null, $sayfaNo = null, $siralamaDegeri = null, $siralamaYonu = null)
    {
        $this
            ->setKayitSayisi($kayitSayisi)
            ->setSayfaNo($sayfaNo)
            ->setSiralamaDegeri($siralamaDegeri)
            ->setSiralamaYonu($siralamaYonu);
    }
    /**
     * Get KayitSayisi value
     * @return int|null
     */
    public function getKayitSayisi()
    {
        return $this->KayitSayisi;
    }
    /**
     * Set KayitSayisi value
     * @param int $kayitSayisi
     * @return \StructType\WebServisSayfalama
     */
    public function setKayitSayisi($kayitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($kayitSayisi) && !(is_int($kayitSayisi) || ctype_digit($kayitSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kayitSayisi, true), gettype($kayitSayisi)), __LINE__);
        }
        $this->KayitSayisi = $kayitSayisi;
        return $this;
    }
    /**
     * Get SayfaNo value
     * @return int|null
     */
    public function getSayfaNo()
    {
        return $this->SayfaNo;
    }
    /**
     * Set SayfaNo value
     * @param int $sayfaNo
     * @return \StructType\WebServisSayfalama
     */
    public function setSayfaNo($sayfaNo = null)
    {
        // validation for constraint: int
        if (!is_null($sayfaNo) && !(is_int($sayfaNo) || ctype_digit($sayfaNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sayfaNo, true), gettype($sayfaNo)), __LINE__);
        }
        $this->SayfaNo = $sayfaNo;
        return $this;
    }
    /**
     * Get SiralamaDegeri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiralamaDegeri()
    {
        return isset($this->SiralamaDegeri) ? $this->SiralamaDegeri : null;
    }
    /**
     * Set SiralamaDegeri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siralamaDegeri
     * @return \StructType\WebServisSayfalama
     */
    public function setSiralamaDegeri($siralamaDegeri = null)
    {
        // validation for constraint: string
        if (!is_null($siralamaDegeri) && !is_string($siralamaDegeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siralamaDegeri, true), gettype($siralamaDegeri)), __LINE__);
        }
        if (is_null($siralamaDegeri) || (is_array($siralamaDegeri) && empty($siralamaDegeri))) {
            unset($this->SiralamaDegeri);
        } else {
            $this->SiralamaDegeri = $siralamaDegeri;
        }
        return $this;
    }
    /**
     * Get SiralamaYonu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiralamaYonu()
    {
        return isset($this->SiralamaYonu) ? $this->SiralamaYonu : null;
    }
    /**
     * Set SiralamaYonu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siralamaYonu
     * @return \StructType\WebServisSayfalama
     */
    public function setSiralamaYonu($siralamaYonu = null)
    {
        // validation for constraint: string
        if (!is_null($siralamaYonu) && !is_string($siralamaYonu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siralamaYonu, true), gettype($siralamaYonu)), __LINE__);
        }
        if (is_null($siralamaYonu) || (is_array($siralamaYonu) && empty($siralamaYonu))) {
            unset($this->SiralamaYonu);
        } else {
            $this->SiralamaYonu = $siralamaYonu;
        }
        return $this;
    }
}
