<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiparisMarketplaceBilgi StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SiparisMarketplaceBilgi
 * @subpackage Structs
 */
class SiparisMarketplaceBilgi extends AbstractStructBase
{
    /**
     * The DigerFaturaNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DigerFaturaNo;
    /**
     * The IadeKomisyonFaturaNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IadeKomisyonFaturaNo;
    /**
     * The KargoKatkiPayi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KargoKatkiPayi;
    /**
     * The KargoKatkiPayiFaturaNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoKatkiPayiFaturaNo;
    /**
     * The KomisyonFaturaNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KomisyonFaturaNo;
    /**
     * The MarketPlaceOdemeAlindi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MarketPlaceOdemeAlindi;
    /**
     * The OdemeVadeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdemeVadeTarihi;
    /**
     * The PazaryeriKomisyonTutari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PazaryeriKomisyonTutari;
    /**
     * The PazaryeriOdemeTutari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PazaryeriOdemeTutari;
    /**
     * The SiparisDurum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisDurum;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisKaynagi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisKaynagi;
    /**
     * The SiparisNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisNo;
    /**
     * Constructor method for SiparisMarketplaceBilgi
     * @uses SiparisMarketplaceBilgi::setDigerFaturaNo()
     * @uses SiparisMarketplaceBilgi::setIadeKomisyonFaturaNo()
     * @uses SiparisMarketplaceBilgi::setKargoKatkiPayi()
     * @uses SiparisMarketplaceBilgi::setKargoKatkiPayiFaturaNo()
     * @uses SiparisMarketplaceBilgi::setKomisyonFaturaNo()
     * @uses SiparisMarketplaceBilgi::setMarketPlaceOdemeAlindi()
     * @uses SiparisMarketplaceBilgi::setOdemeVadeTarihi()
     * @uses SiparisMarketplaceBilgi::setPazaryeriKomisyonTutari()
     * @uses SiparisMarketplaceBilgi::setPazaryeriOdemeTutari()
     * @uses SiparisMarketplaceBilgi::setSiparisDurum()
     * @uses SiparisMarketplaceBilgi::setSiparisID()
     * @uses SiparisMarketplaceBilgi::setSiparisKaynagi()
     * @uses SiparisMarketplaceBilgi::setSiparisNo()
     * @param string $digerFaturaNo
     * @param string $iadeKomisyonFaturaNo
     * @param float $kargoKatkiPayi
     * @param string $kargoKatkiPayiFaturaNo
     * @param string $komisyonFaturaNo
     * @param bool $marketPlaceOdemeAlindi
     * @param string $odemeVadeTarihi
     * @param float $pazaryeriKomisyonTutari
     * @param float $pazaryeriOdemeTutari
     * @param int $siparisDurum
     * @param int $siparisID
     * @param string $siparisKaynagi
     * @param string $siparisNo
     */
    public function __construct($digerFaturaNo = null, $iadeKomisyonFaturaNo = null, $kargoKatkiPayi = null, $kargoKatkiPayiFaturaNo = null, $komisyonFaturaNo = null, $marketPlaceOdemeAlindi = null, $odemeVadeTarihi = null, $pazaryeriKomisyonTutari = null, $pazaryeriOdemeTutari = null, $siparisDurum = null, $siparisID = null, $siparisKaynagi = null, $siparisNo = null)
    {
        $this
            ->setDigerFaturaNo($digerFaturaNo)
            ->setIadeKomisyonFaturaNo($iadeKomisyonFaturaNo)
            ->setKargoKatkiPayi($kargoKatkiPayi)
            ->setKargoKatkiPayiFaturaNo($kargoKatkiPayiFaturaNo)
            ->setKomisyonFaturaNo($komisyonFaturaNo)
            ->setMarketPlaceOdemeAlindi($marketPlaceOdemeAlindi)
            ->setOdemeVadeTarihi($odemeVadeTarihi)
            ->setPazaryeriKomisyonTutari($pazaryeriKomisyonTutari)
            ->setPazaryeriOdemeTutari($pazaryeriOdemeTutari)
            ->setSiparisDurum($siparisDurum)
            ->setSiparisID($siparisID)
            ->setSiparisKaynagi($siparisKaynagi)
            ->setSiparisNo($siparisNo);
    }
    /**
     * Get DigerFaturaNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDigerFaturaNo()
    {
        return isset($this->DigerFaturaNo) ? $this->DigerFaturaNo : null;
    }
    /**
     * Set DigerFaturaNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $digerFaturaNo
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setDigerFaturaNo($digerFaturaNo = null)
    {
        // validation for constraint: string
        if (!is_null($digerFaturaNo) && !is_string($digerFaturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digerFaturaNo, true), gettype($digerFaturaNo)), __LINE__);
        }
        if (is_null($digerFaturaNo) || (is_array($digerFaturaNo) && empty($digerFaturaNo))) {
            unset($this->DigerFaturaNo);
        } else {
            $this->DigerFaturaNo = $digerFaturaNo;
        }
        return $this;
    }
    /**
     * Get IadeKomisyonFaturaNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIadeKomisyonFaturaNo()
    {
        return isset($this->IadeKomisyonFaturaNo) ? $this->IadeKomisyonFaturaNo : null;
    }
    /**
     * Set IadeKomisyonFaturaNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iadeKomisyonFaturaNo
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setIadeKomisyonFaturaNo($iadeKomisyonFaturaNo = null)
    {
        // validation for constraint: string
        if (!is_null($iadeKomisyonFaturaNo) && !is_string($iadeKomisyonFaturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iadeKomisyonFaturaNo, true), gettype($iadeKomisyonFaturaNo)), __LINE__);
        }
        if (is_null($iadeKomisyonFaturaNo) || (is_array($iadeKomisyonFaturaNo) && empty($iadeKomisyonFaturaNo))) {
            unset($this->IadeKomisyonFaturaNo);
        } else {
            $this->IadeKomisyonFaturaNo = $iadeKomisyonFaturaNo;
        }
        return $this;
    }
    /**
     * Get KargoKatkiPayi value
     * @return float|null
     */
    public function getKargoKatkiPayi()
    {
        return $this->KargoKatkiPayi;
    }
    /**
     * Set KargoKatkiPayi value
     * @param float $kargoKatkiPayi
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setKargoKatkiPayi($kargoKatkiPayi = null)
    {
        // validation for constraint: float
        if (!is_null($kargoKatkiPayi) && !(is_float($kargoKatkiPayi) || is_numeric($kargoKatkiPayi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kargoKatkiPayi, true), gettype($kargoKatkiPayi)), __LINE__);
        }
        $this->KargoKatkiPayi = $kargoKatkiPayi;
        return $this;
    }
    /**
     * Get KargoKatkiPayiFaturaNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoKatkiPayiFaturaNo()
    {
        return isset($this->KargoKatkiPayiFaturaNo) ? $this->KargoKatkiPayiFaturaNo : null;
    }
    /**
     * Set KargoKatkiPayiFaturaNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoKatkiPayiFaturaNo
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setKargoKatkiPayiFaturaNo($kargoKatkiPayiFaturaNo = null)
    {
        // validation for constraint: string
        if (!is_null($kargoKatkiPayiFaturaNo) && !is_string($kargoKatkiPayiFaturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoKatkiPayiFaturaNo, true), gettype($kargoKatkiPayiFaturaNo)), __LINE__);
        }
        if (is_null($kargoKatkiPayiFaturaNo) || (is_array($kargoKatkiPayiFaturaNo) && empty($kargoKatkiPayiFaturaNo))) {
            unset($this->KargoKatkiPayiFaturaNo);
        } else {
            $this->KargoKatkiPayiFaturaNo = $kargoKatkiPayiFaturaNo;
        }
        return $this;
    }
    /**
     * Get KomisyonFaturaNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKomisyonFaturaNo()
    {
        return isset($this->KomisyonFaturaNo) ? $this->KomisyonFaturaNo : null;
    }
    /**
     * Set KomisyonFaturaNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $komisyonFaturaNo
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setKomisyonFaturaNo($komisyonFaturaNo = null)
    {
        // validation for constraint: string
        if (!is_null($komisyonFaturaNo) && !is_string($komisyonFaturaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($komisyonFaturaNo, true), gettype($komisyonFaturaNo)), __LINE__);
        }
        if (is_null($komisyonFaturaNo) || (is_array($komisyonFaturaNo) && empty($komisyonFaturaNo))) {
            unset($this->KomisyonFaturaNo);
        } else {
            $this->KomisyonFaturaNo = $komisyonFaturaNo;
        }
        return $this;
    }
    /**
     * Get MarketPlaceOdemeAlindi value
     * @return bool|null
     */
    public function getMarketPlaceOdemeAlindi()
    {
        return $this->MarketPlaceOdemeAlindi;
    }
    /**
     * Set MarketPlaceOdemeAlindi value
     * @param bool $marketPlaceOdemeAlindi
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setMarketPlaceOdemeAlindi($marketPlaceOdemeAlindi = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketPlaceOdemeAlindi) && !is_bool($marketPlaceOdemeAlindi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marketPlaceOdemeAlindi, true), gettype($marketPlaceOdemeAlindi)), __LINE__);
        }
        $this->MarketPlaceOdemeAlindi = $marketPlaceOdemeAlindi;
        return $this;
    }
    /**
     * Get OdemeVadeTarihi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdemeVadeTarihi()
    {
        return isset($this->OdemeVadeTarihi) ? $this->OdemeVadeTarihi : null;
    }
    /**
     * Set OdemeVadeTarihi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odemeVadeTarihi
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setOdemeVadeTarihi($odemeVadeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($odemeVadeTarihi) && !is_string($odemeVadeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odemeVadeTarihi, true), gettype($odemeVadeTarihi)), __LINE__);
        }
        if (is_null($odemeVadeTarihi) || (is_array($odemeVadeTarihi) && empty($odemeVadeTarihi))) {
            unset($this->OdemeVadeTarihi);
        } else {
            $this->OdemeVadeTarihi = $odemeVadeTarihi;
        }
        return $this;
    }
    /**
     * Get PazaryeriKomisyonTutari value
     * @return float|null
     */
    public function getPazaryeriKomisyonTutari()
    {
        return $this->PazaryeriKomisyonTutari;
    }
    /**
     * Set PazaryeriKomisyonTutari value
     * @param float $pazaryeriKomisyonTutari
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setPazaryeriKomisyonTutari($pazaryeriKomisyonTutari = null)
    {
        // validation for constraint: float
        if (!is_null($pazaryeriKomisyonTutari) && !(is_float($pazaryeriKomisyonTutari) || is_numeric($pazaryeriKomisyonTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pazaryeriKomisyonTutari, true), gettype($pazaryeriKomisyonTutari)), __LINE__);
        }
        $this->PazaryeriKomisyonTutari = $pazaryeriKomisyonTutari;
        return $this;
    }
    /**
     * Get PazaryeriOdemeTutari value
     * @return float|null
     */
    public function getPazaryeriOdemeTutari()
    {
        return $this->PazaryeriOdemeTutari;
    }
    /**
     * Set PazaryeriOdemeTutari value
     * @param float $pazaryeriOdemeTutari
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setPazaryeriOdemeTutari($pazaryeriOdemeTutari = null)
    {
        // validation for constraint: float
        if (!is_null($pazaryeriOdemeTutari) && !(is_float($pazaryeriOdemeTutari) || is_numeric($pazaryeriOdemeTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pazaryeriOdemeTutari, true), gettype($pazaryeriOdemeTutari)), __LINE__);
        }
        $this->PazaryeriOdemeTutari = $pazaryeriOdemeTutari;
        return $this;
    }
    /**
     * Get SiparisDurum value
     * @return int|null
     */
    public function getSiparisDurum()
    {
        return $this->SiparisDurum;
    }
    /**
     * Set SiparisDurum value
     * @param int $siparisDurum
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setSiparisDurum($siparisDurum = null)
    {
        // validation for constraint: int
        if (!is_null($siparisDurum) && !(is_int($siparisDurum) || ctype_digit($siparisDurum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisDurum, true), gettype($siparisDurum)), __LINE__);
        }
        $this->SiparisDurum = $siparisDurum;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisKaynagi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisKaynagi()
    {
        return isset($this->SiparisKaynagi) ? $this->SiparisKaynagi : null;
    }
    /**
     * Set SiparisKaynagi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisKaynagi
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setSiparisKaynagi($siparisKaynagi = null)
    {
        // validation for constraint: string
        if (!is_null($siparisKaynagi) && !is_string($siparisKaynagi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisKaynagi, true), gettype($siparisKaynagi)), __LINE__);
        }
        if (is_null($siparisKaynagi) || (is_array($siparisKaynagi) && empty($siparisKaynagi))) {
            unset($this->SiparisKaynagi);
        } else {
            $this->SiparisKaynagi = $siparisKaynagi;
        }
        return $this;
    }
    /**
     * Get SiparisNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisNo()
    {
        return isset($this->SiparisNo) ? $this->SiparisNo : null;
    }
    /**
     * Set SiparisNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisNo
     * @return \StructType\SiparisMarketplaceBilgi
     */
    public function setSiparisNo($siparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($siparisNo) && !is_string($siparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisNo, true), gettype($siparisNo)), __LINE__);
        }
        if (is_null($siparisNo) || (is_array($siparisNo) && empty($siparisNo))) {
            unset($this->SiparisNo);
        } else {
            $this->SiparisNo = $siparisNo;
        }
        return $this;
    }
}
