<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetKampanyaV2 StructType
 * @subpackage Structs
 */
class GetKampanyaV2 extends AbstractStructBase
{
    /**
     * The UyeKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeKodu;
    /**
     * The KampanyaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KampanyaId;
    /**
     * Constructor method for GetKampanyaV2
     * @uses GetKampanyaV2::setUyeKodu()
     * @uses GetKampanyaV2::setKampanyaId()
     * @param string $uyeKodu
     * @param int $kampanyaId
     */
    public function __construct($uyeKodu = null, $kampanyaId = null)
    {
        $this
            ->setUyeKodu($uyeKodu)
            ->setKampanyaId($kampanyaId);
    }
    /**
     * Get UyeKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeKodu()
    {
        return isset($this->UyeKodu) ? $this->UyeKodu : null;
    }
    /**
     * Set UyeKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeKodu
     * @return \StructType\GetKampanyaV2
     */
    public function setUyeKodu($uyeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($uyeKodu) && !is_string($uyeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeKodu, true), gettype($uyeKodu)), __LINE__);
        }
        if (is_null($uyeKodu) || (is_array($uyeKodu) && empty($uyeKodu))) {
            unset($this->UyeKodu);
        } else {
            $this->UyeKodu = $uyeKodu;
        }
        return $this;
    }
    /**
     * Get KampanyaId value
     * @return int|null
     */
    public function getKampanyaId()
    {
        return $this->KampanyaId;
    }
    /**
     * Set KampanyaId value
     * @param int $kampanyaId
     * @return \StructType\GetKampanyaV2
     */
    public function setKampanyaId($kampanyaId = null)
    {
        // validation for constraint: int
        if (!is_null($kampanyaId) && !(is_int($kampanyaId) || ctype_digit($kampanyaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kampanyaId, true), gettype($kampanyaId)), __LINE__);
        }
        $this->KampanyaId = $kampanyaId;
        return $this;
    }
}
