<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateIadeTalebi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateIadeTalebi $parameters
     * @return \StructType\UpdateIadeTalebiResponse|bool
     */
    public function UpdateIadeTalebi(\StructType\UpdateIadeTalebi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateIadeTalebi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDegisimTalebi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDegisimTalebi $parameters
     * @return \StructType\UpdateDegisimTalebiResponse|bool
     */
    public function UpdateDegisimTalebi(\StructType\UpdateDegisimTalebi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDegisimTalebi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTicketStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTicketStatus $parameters
     * @return \StructType\UpdateTicketStatusResponse|bool
     */
    public function UpdateTicketStatus(\StructType\UpdateTicketStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTicketStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateDegisimTalebiResponse|\StructType\UpdateIadeTalebiResponse|\StructType\UpdateTicketStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
