<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSiparisOdemeDurumRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetSiparisOdemeDurumRequest
 * @subpackage Structs
 */
class SetSiparisOdemeDurumRequest extends AbstractStructBase
{
    /**
     * The BilgiMailiGonderme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BilgiMailiGonderme;
    /**
     * The OdemeDurum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OdemeDurum;
    /**
     * The OdemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OdemeId;
    /**
     * The SiparisId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisId;
    /**
     * Constructor method for SetSiparisOdemeDurumRequest
     * @uses SetSiparisOdemeDurumRequest::setBilgiMailiGonderme()
     * @uses SetSiparisOdemeDurumRequest::setOdemeDurum()
     * @uses SetSiparisOdemeDurumRequest::setOdemeId()
     * @uses SetSiparisOdemeDurumRequest::setSiparisId()
     * @param bool $bilgiMailiGonderme
     * @param string $odemeDurum
     * @param int $odemeId
     * @param int $siparisId
     */
    public function __construct($bilgiMailiGonderme = null, $odemeDurum = null, $odemeId = null, $siparisId = null)
    {
        $this
            ->setBilgiMailiGonderme($bilgiMailiGonderme)
            ->setOdemeDurum($odemeDurum)
            ->setOdemeId($odemeId)
            ->setSiparisId($siparisId);
    }
    /**
     * Get BilgiMailiGonderme value
     * @return bool|null
     */
    public function getBilgiMailiGonderme()
    {
        return $this->BilgiMailiGonderme;
    }
    /**
     * Set BilgiMailiGonderme value
     * @param bool $bilgiMailiGonderme
     * @return \StructType\SetSiparisOdemeDurumRequest
     */
    public function setBilgiMailiGonderme($bilgiMailiGonderme = null)
    {
        // validation for constraint: boolean
        if (!is_null($bilgiMailiGonderme) && !is_bool($bilgiMailiGonderme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bilgiMailiGonderme, true), gettype($bilgiMailiGonderme)), __LINE__);
        }
        $this->BilgiMailiGonderme = $bilgiMailiGonderme;
        return $this;
    }
    /**
     * Get OdemeDurum value
     * @return string|null
     */
    public function getOdemeDurum()
    {
        return $this->OdemeDurum;
    }
    /**
     * Set OdemeDurum value
     * @uses \EnumType\WebOdemeDurumlari::valueIsValid()
     * @uses \EnumType\WebOdemeDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeDurum
     * @return \StructType\SetSiparisOdemeDurumRequest
     */
    public function setOdemeDurum($odemeDurum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebOdemeDurumlari::valueIsValid($odemeDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebOdemeDurumlari', is_array($odemeDurum) ? implode(', ', $odemeDurum) : var_export($odemeDurum, true), implode(', ', \EnumType\WebOdemeDurumlari::getValidValues())), __LINE__);
        }
        $this->OdemeDurum = $odemeDurum;
        return $this;
    }
    /**
     * Get OdemeId value
     * @return int|null
     */
    public function getOdemeId()
    {
        return $this->OdemeId;
    }
    /**
     * Set OdemeId value
     * @param int $odemeId
     * @return \StructType\SetSiparisOdemeDurumRequest
     */
    public function setOdemeId($odemeId = null)
    {
        // validation for constraint: int
        if (!is_null($odemeId) && !(is_int($odemeId) || ctype_digit($odemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odemeId, true), gettype($odemeId)), __LINE__);
        }
        $this->OdemeId = $odemeId;
        return $this;
    }
    /**
     * Get SiparisId value
     * @return int|null
     */
    public function getSiparisId()
    {
        return $this->SiparisId;
    }
    /**
     * Set SiparisId value
     * @param int $siparisId
     * @return \StructType\SetSiparisOdemeDurumRequest
     */
    public function setSiparisId($siparisId = null)
    {
        // validation for constraint: int
        if (!is_null($siparisId) && !(is_int($siparisId) || ctype_digit($siparisId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisId, true), gettype($siparisId)), __LINE__);
        }
        $this->SiparisId = $siparisId;
        return $this;
    }
}
