<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BLHataliOdeme StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BLHataliOdeme
 * @subpackage Structs
 */
class BLHataliOdeme extends AbstractStructBase
{
    /**
     * The Banka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Banka;
    /**
     * The Hata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Hata;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The TaksitSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaksitSayisi;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tarih;
    /**
     * The Tutar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Tutar;
    /**
     * The UyeAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeAdi;
    /**
     * Constructor method for BLHataliOdeme
     * @uses BLHataliOdeme::setBanka()
     * @uses BLHataliOdeme::setHata()
     * @uses BLHataliOdeme::setSiparisID()
     * @uses BLHataliOdeme::setTaksitSayisi()
     * @uses BLHataliOdeme::setTarih()
     * @uses BLHataliOdeme::setTutar()
     * @uses BLHataliOdeme::setUyeAdi()
     * @param string $banka
     * @param string $hata
     * @param int $siparisID
     * @param int $taksitSayisi
     * @param string $tarih
     * @param float $tutar
     * @param string $uyeAdi
     */
    public function __construct($banka = null, $hata = null, $siparisID = null, $taksitSayisi = null, $tarih = null, $tutar = null, $uyeAdi = null)
    {
        $this
            ->setBanka($banka)
            ->setHata($hata)
            ->setSiparisID($siparisID)
            ->setTaksitSayisi($taksitSayisi)
            ->setTarih($tarih)
            ->setTutar($tutar)
            ->setUyeAdi($uyeAdi);
    }
    /**
     * Get Banka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBanka()
    {
        return isset($this->Banka) ? $this->Banka : null;
    }
    /**
     * Set Banka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $banka
     * @return \StructType\BLHataliOdeme
     */
    public function setBanka($banka = null)
    {
        // validation for constraint: string
        if (!is_null($banka) && !is_string($banka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($banka, true), gettype($banka)), __LINE__);
        }
        if (is_null($banka) || (is_array($banka) && empty($banka))) {
            unset($this->Banka);
        } else {
            $this->Banka = $banka;
        }
        return $this;
    }
    /**
     * Get Hata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHata()
    {
        return isset($this->Hata) ? $this->Hata : null;
    }
    /**
     * Set Hata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hata
     * @return \StructType\BLHataliOdeme
     */
    public function setHata($hata = null)
    {
        // validation for constraint: string
        if (!is_null($hata) && !is_string($hata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hata, true), gettype($hata)), __LINE__);
        }
        if (is_null($hata) || (is_array($hata) && empty($hata))) {
            unset($this->Hata);
        } else {
            $this->Hata = $hata;
        }
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\BLHataliOdeme
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get TaksitSayisi value
     * @return int|null
     */
    public function getTaksitSayisi()
    {
        return $this->TaksitSayisi;
    }
    /**
     * Set TaksitSayisi value
     * @param int $taksitSayisi
     * @return \StructType\BLHataliOdeme
     */
    public function setTaksitSayisi($taksitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($taksitSayisi) && !(is_int($taksitSayisi) || ctype_digit($taksitSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taksitSayisi, true), gettype($taksitSayisi)), __LINE__);
        }
        $this->TaksitSayisi = $taksitSayisi;
        return $this;
    }
    /**
     * Get Tarih value
     * @return string|null
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\BLHataliOdeme
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get Tutar value
     * @return float|null
     */
    public function getTutar()
    {
        return $this->Tutar;
    }
    /**
     * Set Tutar value
     * @param float $tutar
     * @return \StructType\BLHataliOdeme
     */
    public function setTutar($tutar = null)
    {
        // validation for constraint: float
        if (!is_null($tutar) && !(is_float($tutar) || is_numeric($tutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tutar, true), gettype($tutar)), __LINE__);
        }
        $this->Tutar = $tutar;
        return $this;
    }
    /**
     * Get UyeAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeAdi()
    {
        return isset($this->UyeAdi) ? $this->UyeAdi : null;
    }
    /**
     * Set UyeAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeAdi
     * @return \StructType\BLHataliOdeme
     */
    public function setUyeAdi($uyeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($uyeAdi) && !is_string($uyeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeAdi, true), gettype($uyeAdi)), __LINE__);
        }
        if (is_null($uyeAdi) || (is_array($uyeAdi) && empty($uyeAdi))) {
            unset($this->UyeAdi);
        } else {
            $this->UyeAdi = $uyeAdi;
        }
        return $this;
    }
}
