<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Marketplace ServiceType
 * @subpackage Services
 */
class Marketplace extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MarketplaceParamsIslem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarketplaceParamsIslem $parameters
     * @return \StructType\MarketplaceParamsIslemResponse|bool
     */
    public function MarketplaceParamsIslem(\StructType\MarketplaceParamsIslem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarketplaceParamsIslem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MarketplaceParamsIslemResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
