<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebHediyeCekiOlusturRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebHediyeCekiOlusturRequest
 * @subpackage Structs
 */
class WebHediyeCekiOlusturRequest extends AbstractStructBase
{
    /**
     * The AndroidAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AndroidAktif;
    /**
     * The BaskaKampanyalarlaBilestirilebilir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BaskaKampanyalarlaBilestirilebilir;
    /**
     * The BirlestirilebilirKampanyalar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBLHediyeCekiKampanya
     */
    public $BirlestirilebilirKampanyalar;
    /**
     * The IOSAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IOSAktif;
    /**
     * The IndirimDegeri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IndirimDegeri;
    /**
     * The IndirimTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IndirimTipi;
    /**
     * The IndirimliUrunleKullanilabilir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IndirimliUrunleKullanilabilir;
    /**
     * The KargoUcretsiz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KargoUcretsiz;
    /**
     * The KategoriId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KategoriId;
    /**
     * The Kod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kod;
    /**
     * The KullanimSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KullanimSayisi;
    /**
     * The MarkaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MarkaID;
    /**
     * The MinTutarKosuldaGecerli
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MinTutarKosuldaGecerli;
    /**
     * The MinimumUrunTutari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MinimumUrunTutari;
    /**
     * The MobilAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MobilAktif;
    /**
     * The TarihBaslagic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TarihBaslagic;
    /**
     * The TarihBitis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TarihBitis;
    /**
     * The UyeAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeAdi;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * The UyeMaksimumKullanimSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeMaksimumKullanimSayisi;
    /**
     * The WebAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $WebAktif;
    /**
     * Constructor method for WebHediyeCekiOlusturRequest
     * @uses WebHediyeCekiOlusturRequest::setAndroidAktif()
     * @uses WebHediyeCekiOlusturRequest::setBaskaKampanyalarlaBilestirilebilir()
     * @uses WebHediyeCekiOlusturRequest::setBirlestirilebilirKampanyalar()
     * @uses WebHediyeCekiOlusturRequest::setIOSAktif()
     * @uses WebHediyeCekiOlusturRequest::setIndirimDegeri()
     * @uses WebHediyeCekiOlusturRequest::setIndirimTipi()
     * @uses WebHediyeCekiOlusturRequest::setIndirimliUrunleKullanilabilir()
     * @uses WebHediyeCekiOlusturRequest::setKargoUcretsiz()
     * @uses WebHediyeCekiOlusturRequest::setKategoriId()
     * @uses WebHediyeCekiOlusturRequest::setKod()
     * @uses WebHediyeCekiOlusturRequest::setKullanimSayisi()
     * @uses WebHediyeCekiOlusturRequest::setMarkaID()
     * @uses WebHediyeCekiOlusturRequest::setMinTutarKosuldaGecerli()
     * @uses WebHediyeCekiOlusturRequest::setMinimumUrunTutari()
     * @uses WebHediyeCekiOlusturRequest::setMobilAktif()
     * @uses WebHediyeCekiOlusturRequest::setTarihBaslagic()
     * @uses WebHediyeCekiOlusturRequest::setTarihBitis()
     * @uses WebHediyeCekiOlusturRequest::setUyeAdi()
     * @uses WebHediyeCekiOlusturRequest::setUyeID()
     * @uses WebHediyeCekiOlusturRequest::setUyeMaksimumKullanimSayisi()
     * @uses WebHediyeCekiOlusturRequest::setWebAktif()
     * @param bool $androidAktif
     * @param bool $baskaKampanyalarlaBilestirilebilir
     * @param \ArrayType\ArrayOfBLHediyeCekiKampanya $birlestirilebilirKampanyalar
     * @param bool $iOSAktif
     * @param float $indirimDegeri
     * @param int $indirimTipi
     * @param bool $indirimliUrunleKullanilabilir
     * @param bool $kargoUcretsiz
     * @param int $kategoriId
     * @param string $kod
     * @param int $kullanimSayisi
     * @param int $markaID
     * @param bool $minTutarKosuldaGecerli
     * @param float $minimumUrunTutari
     * @param bool $mobilAktif
     * @param string $tarihBaslagic
     * @param string $tarihBitis
     * @param string $uyeAdi
     * @param int $uyeID
     * @param int $uyeMaksimumKullanimSayisi
     * @param bool $webAktif
     */
    public function __construct($androidAktif = null, $baskaKampanyalarlaBilestirilebilir = null, \ArrayType\ArrayOfBLHediyeCekiKampanya $birlestirilebilirKampanyalar = null, $iOSAktif = null, $indirimDegeri = null, $indirimTipi = null, $indirimliUrunleKullanilabilir = null, $kargoUcretsiz = null, $kategoriId = null, $kod = null, $kullanimSayisi = null, $markaID = null, $minTutarKosuldaGecerli = null, $minimumUrunTutari = null, $mobilAktif = null, $tarihBaslagic = null, $tarihBitis = null, $uyeAdi = null, $uyeID = null, $uyeMaksimumKullanimSayisi = null, $webAktif = null)
    {
        $this
            ->setAndroidAktif($androidAktif)
            ->setBaskaKampanyalarlaBilestirilebilir($baskaKampanyalarlaBilestirilebilir)
            ->setBirlestirilebilirKampanyalar($birlestirilebilirKampanyalar)
            ->setIOSAktif($iOSAktif)
            ->setIndirimDegeri($indirimDegeri)
            ->setIndirimTipi($indirimTipi)
            ->setIndirimliUrunleKullanilabilir($indirimliUrunleKullanilabilir)
            ->setKargoUcretsiz($kargoUcretsiz)
            ->setKategoriId($kategoriId)
            ->setKod($kod)
            ->setKullanimSayisi($kullanimSayisi)
            ->setMarkaID($markaID)
            ->setMinTutarKosuldaGecerli($minTutarKosuldaGecerli)
            ->setMinimumUrunTutari($minimumUrunTutari)
            ->setMobilAktif($mobilAktif)
            ->setTarihBaslagic($tarihBaslagic)
            ->setTarihBitis($tarihBitis)
            ->setUyeAdi($uyeAdi)
            ->setUyeID($uyeID)
            ->setUyeMaksimumKullanimSayisi($uyeMaksimumKullanimSayisi)
            ->setWebAktif($webAktif);
    }
    /**
     * Get AndroidAktif value
     * @return bool|null
     */
    public function getAndroidAktif()
    {
        return $this->AndroidAktif;
    }
    /**
     * Set AndroidAktif value
     * @param bool $androidAktif
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setAndroidAktif($androidAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($androidAktif) && !is_bool($androidAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($androidAktif, true), gettype($androidAktif)), __LINE__);
        }
        $this->AndroidAktif = $androidAktif;
        return $this;
    }
    /**
     * Get BaskaKampanyalarlaBilestirilebilir value
     * @return bool|null
     */
    public function getBaskaKampanyalarlaBilestirilebilir()
    {
        return $this->BaskaKampanyalarlaBilestirilebilir;
    }
    /**
     * Set BaskaKampanyalarlaBilestirilebilir value
     * @param bool $baskaKampanyalarlaBilestirilebilir
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setBaskaKampanyalarlaBilestirilebilir($baskaKampanyalarlaBilestirilebilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($baskaKampanyalarlaBilestirilebilir) && !is_bool($baskaKampanyalarlaBilestirilebilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($baskaKampanyalarlaBilestirilebilir, true), gettype($baskaKampanyalarlaBilestirilebilir)), __LINE__);
        }
        $this->BaskaKampanyalarlaBilestirilebilir = $baskaKampanyalarlaBilestirilebilir;
        return $this;
    }
    /**
     * Get BirlestirilebilirKampanyalar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBLHediyeCekiKampanya|null
     */
    public function getBirlestirilebilirKampanyalar()
    {
        return isset($this->BirlestirilebilirKampanyalar) ? $this->BirlestirilebilirKampanyalar : null;
    }
    /**
     * Set BirlestirilebilirKampanyalar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBLHediyeCekiKampanya $birlestirilebilirKampanyalar
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setBirlestirilebilirKampanyalar(\ArrayType\ArrayOfBLHediyeCekiKampanya $birlestirilebilirKampanyalar = null)
    {
        if (is_null($birlestirilebilirKampanyalar) || (is_array($birlestirilebilirKampanyalar) && empty($birlestirilebilirKampanyalar))) {
            unset($this->BirlestirilebilirKampanyalar);
        } else {
            $this->BirlestirilebilirKampanyalar = $birlestirilebilirKampanyalar;
        }
        return $this;
    }
    /**
     * Get IOSAktif value
     * @return bool|null
     */
    public function getIOSAktif()
    {
        return $this->IOSAktif;
    }
    /**
     * Set IOSAktif value
     * @param bool $iOSAktif
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setIOSAktif($iOSAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($iOSAktif) && !is_bool($iOSAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iOSAktif, true), gettype($iOSAktif)), __LINE__);
        }
        $this->IOSAktif = $iOSAktif;
        return $this;
    }
    /**
     * Get IndirimDegeri value
     * @return float|null
     */
    public function getIndirimDegeri()
    {
        return $this->IndirimDegeri;
    }
    /**
     * Set IndirimDegeri value
     * @param float $indirimDegeri
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setIndirimDegeri($indirimDegeri = null)
    {
        // validation for constraint: float
        if (!is_null($indirimDegeri) && !(is_float($indirimDegeri) || is_numeric($indirimDegeri))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($indirimDegeri, true), gettype($indirimDegeri)), __LINE__);
        }
        $this->IndirimDegeri = $indirimDegeri;
        return $this;
    }
    /**
     * Get IndirimTipi value
     * @return int|null
     */
    public function getIndirimTipi()
    {
        return $this->IndirimTipi;
    }
    /**
     * Set IndirimTipi value
     * @param int $indirimTipi
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setIndirimTipi($indirimTipi = null)
    {
        // validation for constraint: int
        if (!is_null($indirimTipi) && !(is_int($indirimTipi) || ctype_digit($indirimTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indirimTipi, true), gettype($indirimTipi)), __LINE__);
        }
        $this->IndirimTipi = $indirimTipi;
        return $this;
    }
    /**
     * Get IndirimliUrunleKullanilabilir value
     * @return bool|null
     */
    public function getIndirimliUrunleKullanilabilir()
    {
        return $this->IndirimliUrunleKullanilabilir;
    }
    /**
     * Set IndirimliUrunleKullanilabilir value
     * @param bool $indirimliUrunleKullanilabilir
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setIndirimliUrunleKullanilabilir($indirimliUrunleKullanilabilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($indirimliUrunleKullanilabilir) && !is_bool($indirimliUrunleKullanilabilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indirimliUrunleKullanilabilir, true), gettype($indirimliUrunleKullanilabilir)), __LINE__);
        }
        $this->IndirimliUrunleKullanilabilir = $indirimliUrunleKullanilabilir;
        return $this;
    }
    /**
     * Get KargoUcretsiz value
     * @return bool|null
     */
    public function getKargoUcretsiz()
    {
        return $this->KargoUcretsiz;
    }
    /**
     * Set KargoUcretsiz value
     * @param bool $kargoUcretsiz
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setKargoUcretsiz($kargoUcretsiz = null)
    {
        // validation for constraint: boolean
        if (!is_null($kargoUcretsiz) && !is_bool($kargoUcretsiz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kargoUcretsiz, true), gettype($kargoUcretsiz)), __LINE__);
        }
        $this->KargoUcretsiz = $kargoUcretsiz;
        return $this;
    }
    /**
     * Get KategoriId value
     * @return int|null
     */
    public function getKategoriId()
    {
        return $this->KategoriId;
    }
    /**
     * Set KategoriId value
     * @param int $kategoriId
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setKategoriId($kategoriId = null)
    {
        // validation for constraint: int
        if (!is_null($kategoriId) && !(is_int($kategoriId) || ctype_digit($kategoriId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategoriId, true), gettype($kategoriId)), __LINE__);
        }
        $this->KategoriId = $kategoriId;
        return $this;
    }
    /**
     * Get Kod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKod()
    {
        return isset($this->Kod) ? $this->Kod : null;
    }
    /**
     * Set Kod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kod
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setKod($kod = null)
    {
        // validation for constraint: string
        if (!is_null($kod) && !is_string($kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kod, true), gettype($kod)), __LINE__);
        }
        if (is_null($kod) || (is_array($kod) && empty($kod))) {
            unset($this->Kod);
        } else {
            $this->Kod = $kod;
        }
        return $this;
    }
    /**
     * Get KullanimSayisi value
     * @return int|null
     */
    public function getKullanimSayisi()
    {
        return $this->KullanimSayisi;
    }
    /**
     * Set KullanimSayisi value
     * @param int $kullanimSayisi
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setKullanimSayisi($kullanimSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($kullanimSayisi) && !(is_int($kullanimSayisi) || ctype_digit($kullanimSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kullanimSayisi, true), gettype($kullanimSayisi)), __LINE__);
        }
        $this->KullanimSayisi = $kullanimSayisi;
        return $this;
    }
    /**
     * Get MarkaID value
     * @return int|null
     */
    public function getMarkaID()
    {
        return $this->MarkaID;
    }
    /**
     * Set MarkaID value
     * @param int $markaID
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setMarkaID($markaID = null)
    {
        // validation for constraint: int
        if (!is_null($markaID) && !(is_int($markaID) || ctype_digit($markaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($markaID, true), gettype($markaID)), __LINE__);
        }
        $this->MarkaID = $markaID;
        return $this;
    }
    /**
     * Get MinTutarKosuldaGecerli value
     * @return bool|null
     */
    public function getMinTutarKosuldaGecerli()
    {
        return $this->MinTutarKosuldaGecerli;
    }
    /**
     * Set MinTutarKosuldaGecerli value
     * @param bool $minTutarKosuldaGecerli
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setMinTutarKosuldaGecerli($minTutarKosuldaGecerli = null)
    {
        // validation for constraint: boolean
        if (!is_null($minTutarKosuldaGecerli) && !is_bool($minTutarKosuldaGecerli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($minTutarKosuldaGecerli, true), gettype($minTutarKosuldaGecerli)), __LINE__);
        }
        $this->MinTutarKosuldaGecerli = $minTutarKosuldaGecerli;
        return $this;
    }
    /**
     * Get MinimumUrunTutari value
     * @return float|null
     */
    public function getMinimumUrunTutari()
    {
        return $this->MinimumUrunTutari;
    }
    /**
     * Set MinimumUrunTutari value
     * @param float $minimumUrunTutari
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setMinimumUrunTutari($minimumUrunTutari = null)
    {
        // validation for constraint: float
        if (!is_null($minimumUrunTutari) && !(is_float($minimumUrunTutari) || is_numeric($minimumUrunTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumUrunTutari, true), gettype($minimumUrunTutari)), __LINE__);
        }
        $this->MinimumUrunTutari = $minimumUrunTutari;
        return $this;
    }
    /**
     * Get MobilAktif value
     * @return bool|null
     */
    public function getMobilAktif()
    {
        return $this->MobilAktif;
    }
    /**
     * Set MobilAktif value
     * @param bool $mobilAktif
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setMobilAktif($mobilAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobilAktif) && !is_bool($mobilAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobilAktif, true), gettype($mobilAktif)), __LINE__);
        }
        $this->MobilAktif = $mobilAktif;
        return $this;
    }
    /**
     * Get TarihBaslagic value
     * @return string|null
     */
    public function getTarihBaslagic()
    {
        return $this->TarihBaslagic;
    }
    /**
     * Set TarihBaslagic value
     * @param string $tarihBaslagic
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setTarihBaslagic($tarihBaslagic = null)
    {
        // validation for constraint: string
        if (!is_null($tarihBaslagic) && !is_string($tarihBaslagic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarihBaslagic, true), gettype($tarihBaslagic)), __LINE__);
        }
        $this->TarihBaslagic = $tarihBaslagic;
        return $this;
    }
    /**
     * Get TarihBitis value
     * @return string|null
     */
    public function getTarihBitis()
    {
        return $this->TarihBitis;
    }
    /**
     * Set TarihBitis value
     * @param string $tarihBitis
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setTarihBitis($tarihBitis = null)
    {
        // validation for constraint: string
        if (!is_null($tarihBitis) && !is_string($tarihBitis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarihBitis, true), gettype($tarihBitis)), __LINE__);
        }
        $this->TarihBitis = $tarihBitis;
        return $this;
    }
    /**
     * Get UyeAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeAdi()
    {
        return isset($this->UyeAdi) ? $this->UyeAdi : null;
    }
    /**
     * Set UyeAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeAdi
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setUyeAdi($uyeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($uyeAdi) && !is_string($uyeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeAdi, true), gettype($uyeAdi)), __LINE__);
        }
        if (is_null($uyeAdi) || (is_array($uyeAdi) && empty($uyeAdi))) {
            unset($this->UyeAdi);
        } else {
            $this->UyeAdi = $uyeAdi;
        }
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
    /**
     * Get UyeMaksimumKullanimSayisi value
     * @return int|null
     */
    public function getUyeMaksimumKullanimSayisi()
    {
        return $this->UyeMaksimumKullanimSayisi;
    }
    /**
     * Set UyeMaksimumKullanimSayisi value
     * @param int $uyeMaksimumKullanimSayisi
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setUyeMaksimumKullanimSayisi($uyeMaksimumKullanimSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($uyeMaksimumKullanimSayisi) && !(is_int($uyeMaksimumKullanimSayisi) || ctype_digit($uyeMaksimumKullanimSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeMaksimumKullanimSayisi, true), gettype($uyeMaksimumKullanimSayisi)), __LINE__);
        }
        $this->UyeMaksimumKullanimSayisi = $uyeMaksimumKullanimSayisi;
        return $this;
    }
    /**
     * Get WebAktif value
     * @return bool|null
     */
    public function getWebAktif()
    {
        return $this->WebAktif;
    }
    /**
     * Set WebAktif value
     * @param bool $webAktif
     * @return \StructType\WebHediyeCekiOlusturRequest
     */
    public function setWebAktif($webAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($webAktif) && !is_bool($webAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($webAktif, true), gettype($webAktif)), __LINE__);
        }
        $this->WebAktif = $webAktif;
        return $this;
    }
}
