<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSiparisUrunDurumResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetSiparisUrunDurumResponse
 * @subpackage Structs
 */
class SetSiparisUrunDurumResponse extends WebServisResponse
{
    /**
     * The OdemeDurum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OdemeDurum;
    /**
     * The OdemeHataMesaj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdemeHataMesaj;
    /**
     * The SetSiparisUrunDurumResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SetSiparisUrunDurumResponse
     */
    public $SetSiparisUrunDurumResult;
    /**
     * Constructor method for SetSiparisUrunDurumResponse
     * @uses SetSiparisUrunDurumResponse::setOdemeDurum()
     * @uses SetSiparisUrunDurumResponse::setOdemeHataMesaj()
     * @uses SetSiparisUrunDurumResponse::setSetSiparisUrunDurumResult()
     * @param string $odemeDurum
     * @param string $odemeHataMesaj
     * @param \StructType\SetSiparisUrunDurumResponse $setSiparisUrunDurumResult
     */
    public function __construct($odemeDurum = null, $odemeHataMesaj = null, \StructType\SetSiparisUrunDurumResponse $setSiparisUrunDurumResult = null)
    {
        $this
            ->setOdemeDurum($odemeDurum)
            ->setOdemeHataMesaj($odemeHataMesaj)
            ->setSetSiparisUrunDurumResult($setSiparisUrunDurumResult);
    }
    /**
     * Get OdemeDurum value
     * @return string|null
     */
    public function getOdemeDurum()
    {
        return $this->OdemeDurum;
    }
    /**
     * Set OdemeDurum value
     * @uses \EnumType\BLEnums_OdemeDurumlari::valueIsValid()
     * @uses \EnumType\BLEnums_OdemeDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeDurum
     * @return \StructType\SetSiparisUrunDurumResponse
     */
    public function setOdemeDurum($odemeDurum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BLEnums_OdemeDurumlari::valueIsValid($odemeDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BLEnums_OdemeDurumlari', is_array($odemeDurum) ? implode(', ', $odemeDurum) : var_export($odemeDurum, true), implode(', ', \EnumType\BLEnums_OdemeDurumlari::getValidValues())), __LINE__);
        }
        $this->OdemeDurum = $odemeDurum;
        return $this;
    }
    /**
     * Get OdemeHataMesaj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdemeHataMesaj()
    {
        return isset($this->OdemeHataMesaj) ? $this->OdemeHataMesaj : null;
    }
    /**
     * Set OdemeHataMesaj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odemeHataMesaj
     * @return \StructType\SetSiparisUrunDurumResponse
     */
    public function setOdemeHataMesaj($odemeHataMesaj = null)
    {
        // validation for constraint: string
        if (!is_null($odemeHataMesaj) && !is_string($odemeHataMesaj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odemeHataMesaj, true), gettype($odemeHataMesaj)), __LINE__);
        }
        if (is_null($odemeHataMesaj) || (is_array($odemeHataMesaj) && empty($odemeHataMesaj))) {
            unset($this->OdemeHataMesaj);
        } else {
            $this->OdemeHataMesaj = $odemeHataMesaj;
        }
        return $this;
    }
    /**
     * Get SetSiparisUrunDurumResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SetSiparisUrunDurumResponse|null
     */
    public function getSetSiparisUrunDurumResult()
    {
        return isset($this->SetSiparisUrunDurumResult) ? $this->SetSiparisUrunDurumResult : null;
    }
    /**
     * Set SetSiparisUrunDurumResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SetSiparisUrunDurumResponse $setSiparisUrunDurumResult
     * @return \StructType\SetSiparisUrunDurumResponse
     */
    public function setSetSiparisUrunDurumResult(\StructType\SetSiparisUrunDurumResponse $setSiparisUrunDurumResult = null)
    {
        if (is_null($setSiparisUrunDurumResult) || (is_array($setSiparisUrunDurumResult) && empty($setSiparisUrunDurumResult))) {
            unset($this->SetSiparisUrunDurumResult);
        } else {
            $this->SetSiparisUrunDurumResult = $setSiparisUrunDurumResult;
        }
        return $this;
    }
}
