<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PuanKullanim StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PuanKullanim
 * @subpackage Structs
 */
class PuanKullanim extends AbstractStructBase
{
    /**
     * The KartNumarasi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KartNumarasi;
    /**
     * The KazanilanPuan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KazanilanPuan;
    /**
     * The KazanilanPuanTLKarsiligi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KazanilanPuanTLKarsiligi;
    /**
     * The KullanilanPuan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KullanilanPuan;
    /**
     * The KullanilanPuanTLKarsiligi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KullanilanPuanTLKarsiligi;
    /**
     * The KullanimTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $KullanimTarihi;
    /**
     * The PuanBildirildi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PuanBildirildi;
    /**
     * The Tip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * Constructor method for PuanKullanim
     * @uses PuanKullanim::setKartNumarasi()
     * @uses PuanKullanim::setKazanilanPuan()
     * @uses PuanKullanim::setKazanilanPuanTLKarsiligi()
     * @uses PuanKullanim::setKullanilanPuan()
     * @uses PuanKullanim::setKullanilanPuanTLKarsiligi()
     * @uses PuanKullanim::setKullanimTarihi()
     * @uses PuanKullanim::setPuanBildirildi()
     * @uses PuanKullanim::setTip()
     * @param string $kartNumarasi
     * @param float $kazanilanPuan
     * @param float $kazanilanPuanTLKarsiligi
     * @param float $kullanilanPuan
     * @param float $kullanilanPuanTLKarsiligi
     * @param string $kullanimTarihi
     * @param bool $puanBildirildi
     * @param int $tip
     */
    public function __construct($kartNumarasi = null, $kazanilanPuan = null, $kazanilanPuanTLKarsiligi = null, $kullanilanPuan = null, $kullanilanPuanTLKarsiligi = null, $kullanimTarihi = null, $puanBildirildi = null, $tip = null)
    {
        $this
            ->setKartNumarasi($kartNumarasi)
            ->setKazanilanPuan($kazanilanPuan)
            ->setKazanilanPuanTLKarsiligi($kazanilanPuanTLKarsiligi)
            ->setKullanilanPuan($kullanilanPuan)
            ->setKullanilanPuanTLKarsiligi($kullanilanPuanTLKarsiligi)
            ->setKullanimTarihi($kullanimTarihi)
            ->setPuanBildirildi($puanBildirildi)
            ->setTip($tip);
    }
    /**
     * Get KartNumarasi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKartNumarasi()
    {
        return isset($this->KartNumarasi) ? $this->KartNumarasi : null;
    }
    /**
     * Set KartNumarasi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kartNumarasi
     * @return \StructType\PuanKullanim
     */
    public function setKartNumarasi($kartNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($kartNumarasi) && !is_string($kartNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kartNumarasi, true), gettype($kartNumarasi)), __LINE__);
        }
        if (is_null($kartNumarasi) || (is_array($kartNumarasi) && empty($kartNumarasi))) {
            unset($this->KartNumarasi);
        } else {
            $this->KartNumarasi = $kartNumarasi;
        }
        return $this;
    }
    /**
     * Get KazanilanPuan value
     * @return float|null
     */
    public function getKazanilanPuan()
    {
        return $this->KazanilanPuan;
    }
    /**
     * Set KazanilanPuan value
     * @param float $kazanilanPuan
     * @return \StructType\PuanKullanim
     */
    public function setKazanilanPuan($kazanilanPuan = null)
    {
        // validation for constraint: float
        if (!is_null($kazanilanPuan) && !(is_float($kazanilanPuan) || is_numeric($kazanilanPuan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kazanilanPuan, true), gettype($kazanilanPuan)), __LINE__);
        }
        $this->KazanilanPuan = $kazanilanPuan;
        return $this;
    }
    /**
     * Get KazanilanPuanTLKarsiligi value
     * @return float|null
     */
    public function getKazanilanPuanTLKarsiligi()
    {
        return $this->KazanilanPuanTLKarsiligi;
    }
    /**
     * Set KazanilanPuanTLKarsiligi value
     * @param float $kazanilanPuanTLKarsiligi
     * @return \StructType\PuanKullanim
     */
    public function setKazanilanPuanTLKarsiligi($kazanilanPuanTLKarsiligi = null)
    {
        // validation for constraint: float
        if (!is_null($kazanilanPuanTLKarsiligi) && !(is_float($kazanilanPuanTLKarsiligi) || is_numeric($kazanilanPuanTLKarsiligi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kazanilanPuanTLKarsiligi, true), gettype($kazanilanPuanTLKarsiligi)), __LINE__);
        }
        $this->KazanilanPuanTLKarsiligi = $kazanilanPuanTLKarsiligi;
        return $this;
    }
    /**
     * Get KullanilanPuan value
     * @return float|null
     */
    public function getKullanilanPuan()
    {
        return $this->KullanilanPuan;
    }
    /**
     * Set KullanilanPuan value
     * @param float $kullanilanPuan
     * @return \StructType\PuanKullanim
     */
    public function setKullanilanPuan($kullanilanPuan = null)
    {
        // validation for constraint: float
        if (!is_null($kullanilanPuan) && !(is_float($kullanilanPuan) || is_numeric($kullanilanPuan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kullanilanPuan, true), gettype($kullanilanPuan)), __LINE__);
        }
        $this->KullanilanPuan = $kullanilanPuan;
        return $this;
    }
    /**
     * Get KullanilanPuanTLKarsiligi value
     * @return float|null
     */
    public function getKullanilanPuanTLKarsiligi()
    {
        return $this->KullanilanPuanTLKarsiligi;
    }
    /**
     * Set KullanilanPuanTLKarsiligi value
     * @param float $kullanilanPuanTLKarsiligi
     * @return \StructType\PuanKullanim
     */
    public function setKullanilanPuanTLKarsiligi($kullanilanPuanTLKarsiligi = null)
    {
        // validation for constraint: float
        if (!is_null($kullanilanPuanTLKarsiligi) && !(is_float($kullanilanPuanTLKarsiligi) || is_numeric($kullanilanPuanTLKarsiligi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kullanilanPuanTLKarsiligi, true), gettype($kullanilanPuanTLKarsiligi)), __LINE__);
        }
        $this->KullanilanPuanTLKarsiligi = $kullanilanPuanTLKarsiligi;
        return $this;
    }
    /**
     * Get KullanimTarihi value
     * @return string|null
     */
    public function getKullanimTarihi()
    {
        return $this->KullanimTarihi;
    }
    /**
     * Set KullanimTarihi value
     * @param string $kullanimTarihi
     * @return \StructType\PuanKullanim
     */
    public function setKullanimTarihi($kullanimTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($kullanimTarihi) && !is_string($kullanimTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kullanimTarihi, true), gettype($kullanimTarihi)), __LINE__);
        }
        $this->KullanimTarihi = $kullanimTarihi;
        return $this;
    }
    /**
     * Get PuanBildirildi value
     * @return bool|null
     */
    public function getPuanBildirildi()
    {
        return $this->PuanBildirildi;
    }
    /**
     * Set PuanBildirildi value
     * @param bool $puanBildirildi
     * @return \StructType\PuanKullanim
     */
    public function setPuanBildirildi($puanBildirildi = null)
    {
        // validation for constraint: boolean
        if (!is_null($puanBildirildi) && !is_bool($puanBildirildi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($puanBildirildi, true), gettype($puanBildirildi)), __LINE__);
        }
        $this->PuanBildirildi = $puanBildirildi;
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\PuanKullanim
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !(is_int($tip) || ctype_digit($tip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
}
