<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Optimize ServiceType
 * @subpackage Services
 */
class Optimize extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OptimizeUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OptimizeUrun $parameters
     * @return \StructType\OptimizeUrunResponse|bool
     */
    public function OptimizeUrun(\StructType\OptimizeUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OptimizeUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OptimizeUrunResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
