<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateLabelBusinessPackListTwo StructType
 * @subpackage Structs
 */
class GenerateLabelBusinessPackListTwo extends AbstractStructBase
{
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Format;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The AutoDestinationChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoDestinationChange;
    /**
     * The BusinessPackList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBusinessPack
     */
    public $BusinessPackList;
    /**
     * Constructor method for GenerateLabelBusinessPackListTwo
     * @uses GenerateLabelBusinessPackListTwo::setFormat()
     * @uses GenerateLabelBusinessPackListTwo::setPartnerID()
     * @uses GenerateLabelBusinessPackListTwo::setPartnerKey()
     * @uses GenerateLabelBusinessPackListTwo::setAutoDestinationChange()
     * @uses GenerateLabelBusinessPackListTwo::setBusinessPackList()
     * @param string $format
     * @param string $partnerID
     * @param string $partnerKey
     * @param string $autoDestinationChange
     * @param \ArrayType\ArrayOfBusinessPack $businessPackList
     */
    public function __construct($format = null, $partnerID = null, $partnerKey = null, $autoDestinationChange = null, \ArrayType\ArrayOfBusinessPack $businessPackList = null)
    {
        $this
            ->setFormat($format)
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setAutoDestinationChange($autoDestinationChange)
            ->setBusinessPackList($businessPackList);
    }
    /**
     * Get Format value
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses \EnumType\FormatPliku3::valueIsValid()
     * @uses \EnumType\FormatPliku3::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\GenerateLabelBusinessPackListTwo
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormatPliku3::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FormatPliku3', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\FormatPliku3::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\GenerateLabelBusinessPackListTwo
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\GenerateLabelBusinessPackListTwo
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get AutoDestinationChange value
     * @return string|null
     */
    public function getAutoDestinationChange()
    {
        return $this->AutoDestinationChange;
    }
    /**
     * Set AutoDestinationChange value
     * @param string $autoDestinationChange
     * @return \StructType\GenerateLabelBusinessPackListTwo
     */
    public function setAutoDestinationChange($autoDestinationChange = null)
    {
        // validation for constraint: string
        if (!is_null($autoDestinationChange) && !is_string($autoDestinationChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoDestinationChange, true), gettype($autoDestinationChange)), __LINE__);
        }
        $this->AutoDestinationChange = $autoDestinationChange;
        return $this;
    }
    /**
     * Get BusinessPackList value
     * @return \ArrayType\ArrayOfBusinessPack|null
     */
    public function getBusinessPackList()
    {
        return $this->BusinessPackList;
    }
    /**
     * Set BusinessPackList value
     * @param \ArrayType\ArrayOfBusinessPack $businessPackList
     * @return \StructType\GenerateLabelBusinessPackListTwo
     */
    public function setBusinessPackList(\ArrayType\ArrayOfBusinessPack $businessPackList = null)
    {
        $this->BusinessPackList = $businessPackList;
        return $this;
    }
}
