<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateLabelBusinessPackList StructType
 * @subpackage Structs
 */
class GenerateLabelBusinessPackList extends AbstractStructBase
{
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Format;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The BusinessPackList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBusinessPack
     */
    public $BusinessPackList;
    /**
     * Constructor method for GenerateLabelBusinessPackList
     * @uses GenerateLabelBusinessPackList::setFormat()
     * @uses GenerateLabelBusinessPackList::setPartnerID()
     * @uses GenerateLabelBusinessPackList::setPartnerKey()
     * @uses GenerateLabelBusinessPackList::setBusinessPackList()
     * @param string $format
     * @param string $partnerID
     * @param string $partnerKey
     * @param \ArrayType\ArrayOfBusinessPack $businessPackList
     */
    public function __construct($format = null, $partnerID = null, $partnerKey = null, \ArrayType\ArrayOfBusinessPack $businessPackList = null)
    {
        $this
            ->setFormat($format)
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setBusinessPackList($businessPackList);
    }
    /**
     * Get Format value
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses \EnumType\FormatPliku::valueIsValid()
     * @uses \EnumType\FormatPliku::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\GenerateLabelBusinessPackList
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormatPliku::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FormatPliku', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\FormatPliku::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\GenerateLabelBusinessPackList
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\GenerateLabelBusinessPackList
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get BusinessPackList value
     * @return \ArrayType\ArrayOfBusinessPack|null
     */
    public function getBusinessPackList()
    {
        return $this->BusinessPackList;
    }
    /**
     * Set BusinessPackList value
     * @param \ArrayType\ArrayOfBusinessPack $businessPackList
     * @return \StructType\GenerateLabelBusinessPackList
     */
    public function setBusinessPackList(\ArrayType\ArrayOfBusinessPack $businessPackList = null)
    {
        $this->BusinessPackList = $businessPackList;
        return $this;
    }
}
