<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerConfirmPackReturn StructType
 * @subpackage Structs
 */
class CustomerConfirmPackReturn extends AbstractStructBase
{
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * The PartnerKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerKey;
    /**
     * The PackCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackCode;
    /**
     * The ScanPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanPerson;
    /**
     * Constructor method for CustomerConfirmPackReturn
     * @uses CustomerConfirmPackReturn::setPartnerID()
     * @uses CustomerConfirmPackReturn::setPartnerKey()
     * @uses CustomerConfirmPackReturn::setPackCode()
     * @uses CustomerConfirmPackReturn::setScanPerson()
     * @param string $partnerID
     * @param string $partnerKey
     * @param string $packCode
     * @param string $scanPerson
     */
    public function __construct($partnerID = null, $partnerKey = null, $packCode = null, $scanPerson = null)
    {
        $this
            ->setPartnerID($partnerID)
            ->setPartnerKey($partnerKey)
            ->setPackCode($packCode)
            ->setScanPerson($scanPerson);
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \StructType\CustomerConfirmPackReturn
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\CustomerConfirmPackReturn
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerKey, true), gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Get PackCode value
     * @return string|null
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }
    /**
     * Set PackCode value
     * @param string $packCode
     * @return \StructType\CustomerConfirmPackReturn
     */
    public function setPackCode($packCode = null)
    {
        // validation for constraint: string
        if (!is_null($packCode) && !is_string($packCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packCode, true), gettype($packCode)), __LINE__);
        }
        $this->PackCode = $packCode;
        return $this;
    }
    /**
     * Get ScanPerson value
     * @return string|null
     */
    public function getScanPerson()
    {
        return $this->ScanPerson;
    }
    /**
     * Set ScanPerson value
     * @param string $scanPerson
     * @return \StructType\CustomerConfirmPackReturn
     */
    public function setScanPerson($scanPerson = null)
    {
        // validation for constraint: string
        if (!is_null($scanPerson) && !is_string($scanPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanPerson, true), gettype($scanPerson)), __LINE__);
        }
        $this->ScanPerson = $scanPerson;
        return $this;
    }
}
